import { strict as assert } from "assert";
import * as betfunc from "../src/index";
import * as CryptUtils from "../src/CryptUtils";

describe("Test default encryption", function () {
  it("Should be same before and after", function () {
    const ivWord = "ivwordejajeiqofnfheuebau8u84br8";
    const secret = "some word";

    const encrypted = CryptUtils.encryptData(null, ivWord, secret);
    // console.log(encrypted);
    const decrypted = CryptUtils.decryptData(null, encrypted);
    // console.log(decrypted);

    assert(secret === decrypted, "Not the same");
  });

  it("Should be same before and after, alt secret", function () {
    const ivWord = "ivwordejaedasejeiqofnfheuebau8u84br8";
    const secret = "some word";
    CryptUtils.addTestKey("testval", "backabekjabkjdbkjekb");

    const encrypted = CryptUtils.encryptData(":testval", ivWord, secret);
    // console.log(encrypted);
    const decrypted = CryptUtils.decryptData(null, encrypted);
    // console.log(decrypted);

    assert(secret === decrypted, "Not the same");
  });

  it("Should be same before and after", function () {
    const ivWord = "ivwordejaedasejeiqofnfheuebau8u84br8";
    const secret = "some word";

    const encrypted = CryptUtils.encryptData("secret pass", ivWord, secret);
    // console.log(encrypted);
    const decrypted = CryptUtils.decryptData("secret pass", encrypted);
    // console.log(decrypted);

    assert(secret === decrypted, "Not the same");
  });

  it("Should not be same before and after, custom secret vs default", function () {
    const ivWord = "ivwordejaedasejeiqofnfheuebau8u84br8";
    const secret = "some word";

    const encrypted = CryptUtils.encryptData("secret pass", ivWord, secret);
    // console.log(encrypted);
    const decrypted = CryptUtils.decryptData(null, encrypted);
    // console.log(decrypted);

    assert(secret != decrypted, "Were the same but should not be");
  });

  it("Should return null if it can't decrypt", function () {
    const ivWord = "ivwordejaedasejeiqofnfheuebau8u84br8";
    const secret = "some word";

    const decrypted = CryptUtils.decryptData(
      "badpasswordandstuff",
      CryptUtils.encryptData("secret pass", ivWord, secret)
    );
    // console.log(decrypted);

    assert(decrypted == null, "Should not work and so should be null");
  });

  it("Should return null if we don't have the key", function () {
    const ivWord = "ivwordejaedasejeiqofnfheuebau8u84br8";
    const secret = "some word";

    const decrypted = CryptUtils.decryptData(
      ":does_not_exist",
      CryptUtils.encryptData("secret pass", ivWord, secret)
    );
    // console.log(decrypted);

    assert(decrypted == null, "Should not work and so should be null");
  });
});
