import * as CryptUtils from "./CryptUtils";
import * as fs from "fs";
import * as crypto from "crypto";

if (process.argv.length >= 4 && process.argv[2] == "encrypt") {
  const stdinBuffer = fs.readFileSync(0);

  const key = process.argv.length > 4 ? process.argv[4] : null;
  let iv = process.argv[3];
  if (iv == "random") {
    console.log("Generating IV from secure source");
    iv = crypto.randomBytes(48).toString("base64");
    console.log("iv: ", iv);
  }
  console.log(CryptUtils.encryptData(key, iv, stdinBuffer.toString()));
} else if (process.argv.length == 4 && process.argv[2] == "decrypt") {
  const val = CryptUtils.decryptData(null, process.argv[3]);
  if (!val) {
    console.log("Did not decrypt");
  } else {
    console.log(val);
  }
} else {
  console.log("Usage: ");
  console.log("  ", process.argv[0], " encrypt <iv word>");
  console.log(
    "    example: export CONFIG_SECRET='abcd' ; echo -n 'something' | npm run crypt -- ivword"
  );
  console.log("  ", process.argv0, " decrypt <val>");
}

// console.log("--");
// for (const ob in process.argv) {
//   console.log(ob, ": ", process.argv[ob]);
// }
