import * as logging from "./logger";
import * as OddsSink from "./OddsSink";

const logger = logging.topicLogger("book.generic");

type SbTimeReader = (rcvTime: Date, label: string) => Date | null;
type SbTeamStandardizer = (label: string) => string;
type SbGameStandardizer = (labels: string[], timeHint?: string) => string[];
type BsTeamStandardizer = (labels: string) => string[];
type SbPossibleTeamStandardizer = (label: string) => string[];
type SbOddsReader = (value: string) => number;
type SbLiveReader = (message: any) => boolean;
type SbTeamsMessageReader = (message: any) => string[];
type SbTimeMessageReader = (rcvTime: Date, message: any) => Date | null;
type SbDiagnostics = () => any;

type SbLinesMessageReader = (message: any, oddsSink: OddsSink.OddsSink) => void;

const StandardTeams: { [key: string]: string | string[] } = {
  "New York Yankees": "mlb_yankees",
  Yankees: "mlb_yankees",
  "Seattle Mariners": "mlb_mariners",
  Mariners: "mlb_mariners",
  "Cleveland Guardians": "mlb_guardians",
  Guardians: "mlb_guardians",
  "CLE Guardians": "mlb_guardians",
  "Baltimore Orioles": "mlb_orioles",
  Orioles: "mlb_orioles",
  "Texas Rangers": "mlb_rangers",
  Rangers: ["mlb_rangers", "nhl_rangers"],
  "TEX Rangers": "mlb_rangers",
  "Detroit Tigers": "mlb_tigers",
  Tigers: "mlb_tigers",
  "Kansas City Royals": "mlb_royals",
  Royals: "mlb_royals",
  "St. Louis Cardinals": "mlb_cardinals",
  Cardinals: "mlb_cardinals",
  "STL Cardinals": "mlb_cardinals",
  "Tampa Bay Rays": "mlb_rays",
  "TB Rays": "mlb_rays",
  Rays: "mlb_rays",
  "Chicago Cubs": "mlb_cubs",
  Cubs: "mlb_cubs",
  "Colorado Rockies": "mlb_rockies",
  Rockies: "mlb_rockies",
  "Arizona Diamondbacks": "mlb_diamondbacks",
  "ARI Diamondbacks": "mlb_diamondbacks",
  Diamondbacks: "mlb_diamondbacks",
  "Minnesota Twins": "mlb_twins",
  Twins: "mlb_twins",
  "Houston Astros": "mlb_astros",
  Astros: "mlb_astros",
  "Pittsburgh Pirates": "mlb_pirates",
  Pirates: "mlb_pirates",
  "PIT Pirates": "mlb_pirates",
  "San Francisco Giants": "mlb_giants",
  Giants: "mlb_giants",
  "SF Giants": "mlb_giants",
  "Atlanta Braves": "mlb_braves",
  Braves: "mlb_braves",
  "Oakland Athletics": "mlb_athletics",
  Athletics: "mlb_athletics",
  "OAK Athletics": "mlb_athletics",
  "Los Angeles Angels": "mlb_angels",
  "LA Angels": "mlb_angels",
  Angels: "mlb_angels",
  "Chicago White Sox": "mlb_white_sox",
  "White Sox": "mlb_white_sox",
  "CHI White Sox": "mlb_white_sox",
  "Washington Nationals": "mlb_nationals",
  Nationals: "mlb_nationals",
  "WSH Nationals": "mlb_nationals",
  "Los Angeles Dodgers": "mlb_dodgers",
  "LA Dodgers": "mlb_dodgers",
  Dodgers: "mlb_dodgers",
  "Boston Red Sox": "mlb_red_sox",
  "Red Sox": "mlb_red_sox",
  "Cincinnati Reds": "mlb_reds",
  Reds: "mlb_reds",
  "New York Mets": "mlb_mets",
  Mets: "mlb_mets",
  "Philadelphia Phillies": "mlb_phillies",
  "PHI Phillies": "mlb_phillies",
  Phillies: "mlb_phillies",
  "Toronto Blue Jays": "mlb_blue_jays",
  "Blue Jays": "mlb_blue_jays",
  "Milwaukee Brewers": "mlb_brewers",
  Brewers: "mlb_brewers",
  "Miami Marlins": "mlb_marlins",
  "MIA Marlins": "mlb_marlins",
  Marlins: "mlb_marlins",
  "San Diego Padres": "mlb_padres",
  Padres: "mlb_padres",
  "Boston Celtics": "nba_celtics",
  "BOS Celtics": "nba_celtics",
  Celtics: "nba_celtics",
  "Miami Heat": "nba_heat",
  Heat: "nba_heat",
  "Denver Nuggets": "nba_nuggets",
  "DEN Nuggets": "nba_nuggets",
  Nuggets: "nba_nuggets",
  "MIA HEAT": "nba_heat",
  HEAT: "nba_heat",
  "Boston Bruins": "nhl_Bruins",
  "BOS Bruins": "nhl_Bruins",
  "BUF Sabres": "nhl_Sabres",
  "Buffalo Sabres": "nhl_Sabres",
  Sabres: "nhl_Sabres",
  "DET Red Wings": "nhl_Wings",
  "Red Wings": "nhl_Wings",
  "Detroit Red Wings": "nhl_Wings",
  "FLA Panthers": "nhl_Panthers",
  "FL Panthers": "nhl_Panthers",
  "Florida Panthers": "nhl_Panthers",
  "MTL Canadiens": "nhl_Canadiens",
  Canadiens: "nhl_Canadiens",
  "Montreal Canadiens": "nhl_Canadiens",
  "OTT Senators": "nhl_Senators",
  Senators: "nhl_Senators",
  "Ottawa Senators": "nhl_Senators",
  "Tampa Bay Lightning": "nhl_Lightning",
  Lightning: "nhl_Lightning",
  "TB Lightning": "nhl_Lightning",
  "TOR Maple Leafs": "nhl_Leafs",
  "Toronto Maple Leafs": "nhl_Leafs",
  "Maple Leafs": "nhl_Leafs",
  "ARI Coyotes": "nhl_Coyotes",
  "Arizona Coyotes": "nhl_Coyotes",
  "CHI Blackhawks": "nhl_Blackhawks",
  "Chicago Blackhawks": "nhl_Blackhawks",
  Blackhawks: "nhl_Blackhawks",
  "COL Avalanche": "nhl_Avalanche",
  "Colorado Avalanche": "nhl_Avalanche",
  Avalanche: "nhl_Avalanche",
  "DAL Stars": "nhl_Stars",
  Stars: "nhl_Stars",
  "Dallas Stars": "nhl_Stars",
  "MIN Wild": "nhl_Wild",
  Wild: "nhl_Wild",
  "Minnesota Wild": "nhl_Wild",
  "NSH Predators": "nhl_Predators",
  Predators: "nhl_Predators",
  "Nashville Predators": "nhl_Predators",
  "STL Blues": "nhl_Blues",
  Blues: "nhl_Blues",
  "St. Louis Blues": "nhl_Blues",
  "WPG Jets": "nhl_Jets",
  "Winnipeg Jets": "nhl_Jets",
  "CAR Hurricanes": "nhl_Hurricanes",
  "Carolina Hurricanes": "nhl_Hurricanes",
  "CBJ Blue Jackets": "nhl_Jackets",
  "Blue Jackets": "nhl_Jackets",
  "Columbus Blue Jackets": "nhl_Jackets",
  "NJ Devils": "nhl_Devils",
  Devils: "nhl_Devils",
  "New Jersey Devils": "nhl_Devils",
  "NY Islanders": "nhl_Islanders",
  Islanders: "nhl_Islanders",
  "New York Islanders": "nhl_Islanders",
  "NY Rangers": "nhl_Rangers",
  "New York Rangers": "nhl_Rangers",
  "PHI Flyers": "nhl_Flyers",
  Flyers: "nhl_Flyers",
  "Philadelphia Flyers": "nhl_Flyers",
  "PIT Penguins": "nhl_Penguins",
  "Pittsburgh Penguins": "nhl_Penguins",
  "WAS Capitals": "nhl_Capitals",
  Capitals: "nhl_Capitals",
  "Washington Capitals": "nhl_Capitals",
  "ANA Ducks": "nhl_Ducks",
  "Anaheim Ducks": "nhl_Ducks",
  "CGY Flames": "nhl_Flames",
  "Calgary Flames": "nhl_Flames",
  "CAL Flames": "nhl_Flames",
  "EDM Oilers": "nhl_Oilers",
  Oilers: "nhl_Oilers",
  "Edmonton Oilers": "nhl_Oilers",
  "LA Kings": "nhl_Kings",
  Kings: "nhl_Kings",
  "Los Angeles Kings": "nhl_Kings",
  "SJ Sharks": "nhl_Sharks",
  "San Jose Sharks": "nhl_Sharks",
  "SEA Kraken": "nhl_Kraken",
  Kraken: "nhl_Kraken",
  "Seattle Kraken": "nhl_Kraken",
  "VAN Canucks": "nhl_Canucks",
  "Vancouver Canucks": "nhl_Canucks",
  Canucks: "nhl_Canucks",
  "VGK Golden Knights": "nhl_Knights",
  "LV Golden Knights": "nhl_Knights",
  "Vegas Golden Knights": "nhl_Knights",
  "Golden Knights": "nhl_Knights",
  "Minnesota Lynx": "wnba_lynx",
  "Connecticut Sun": "wnba_sun",
  "SEA Mariners": "mlb_mariners",
  "SD Padres": "mlb_padres",
  "Los Angeles Sparks": "wnba_sparks",
  "Saskatchewan Roughriders": "cfl_roughriders",
  "Edmonton Elks": "cfl_elks",
  "ATL Braves": "mlb_braves",
  "DET Tigers": "mlb_tigers",
  "MIL Brewers": "mlb_brewers",
  "MIN Twins": "mlb_twins",
  "TOR Blue Jays": "mlb_blue_jays",
  "BAL Orioles": "mlb_orioles",
  "COL Rockies": "mlb_rockies",
  "BOS Red Sox": "mlb_red_sox",
  "NY Yankees": "mlb_yankees",
  "NY Mets": "mlb_mets",
  "CIN Reds": "mlb_reds",
  "KC Royals": "mlb_royals",
  "WAS Nationals": "mlb_nationals",
  "HOU Astros": "mlb_astros",
  "SEA Storm": "wnba_storm",
  "Seattle Storm": "wnba_storm",
  "PHX Mercury": "wnba_mercury",
  Mercury: "wnba_mercury",
  "CHI Cubs": "mlb_cubs",
  "Dallas Wings": "wnba_wings",
  "ATL Dream": "wnba_dream",
  Dream: "wnba_dream",
  "Atlanta Dream": "wnba_dream",
  "WAS Mystics": "wnba_mystics",
  Mystics: "wnba_mystics",
  "Washington Mystics": "wnba_mystics",
  "Atlanta Hawks": "nba_hawks",
  "ATL Hawks": "nba_hawks",
  "Brooklyn Nets": "nba_nets",
  "BKN Nets": "nba_nets",
  "Charlotte Hornets": "nba_hornets",
  "CHA Hornets": "nba_hornets",
  "Chicago Bulls": "nba_bulls",
  "CHI Bulls": "nba_bulls",
  "Cleveland Cavaliers": "nba_cavaliers",
  "CLE Cavaliers": "nba_cavaliers",
  "Dallas Mavericks": "nba_mavericks",
  "DAL Mavericks": "nba_mavericks",
  "Detroit Pistons": "nba_pistons",
  "DET Pistons": "nba_pistons",
  "Golden State Warriors": "nba_warriors",
  "GS Warriors": "nba_warriors",
  "GSW Warriors": "nba_warriors",
  "Houston Rockets": "nba_rockets",
  "HOU Rockets": "nba_rockets",
  "Indiana Pacers": "nba_pacers",
  "IND Pacers": "nba_pacers",
  "Los Angeles Clippers": "nba_clippers",
  "LA Clippers": "nba_clippers",
  "LAC Clippers": "nba_clippers",
  "Los Angeles Lakers": "nba_lakers",
  "LA Lakers": "nba_lakers",
  "LAL Lakers": "nba_lakers",
  "Memphis Grizzlies": "nba_grizzlies",
  "MEM Grizzlies": "nba_grizzlies",
  "Milwaukee Bucks": "nba_bucks",
  "MIL Bucks": "nba_bucks",
  "Minnesota Timberwolves": "nba_timberwolves",
  "MIN Timberwolves": "nba_timberwolves",
  "New Orleans Pelicans": "nba_pelicans",
  "NO Pelicans": "nba_pelicans",
  "NOP Pelicans": "nba_pelicans",
  "New York Knicks": "nba_knicks",
  "NY Knicks": "nba_knicks",
  "NYK Knicks": "nba_knicks",
  "Oklahoma City Thunder": "nba_thunder",
  "OKC Thunder": "nba_thunder",
  Thunder: "nba_thunder",
  "Orlando Magic": "nba_magic",
  "ORL Magic": "nba_magic",
  "Philadelphia 76ers": "nba_76ers",
  "PHI 76ers": "nba_76ers",
  "Phoenix Suns": "nba_suns",
  "PHX Suns": "nba_suns",
  Suns: "nba_suns",
  "Portland Trail Blazers": "nba_blazers",
  "POR Trail Blazers": "nba_blazers",
  "Sacramento Kings": "nba_kings",
  "SAC Kings": "nba_kings",
  "San Antonio Spurs": "nba_spurs",
  "SA Spurs": "nba_spurs",
  "SAS Spurs": "nba_spurs",
  "Toronto Raptors": "nba_raptors",
  "TOR Raptors": "nba_raptors",
  Raptors: "nba_raptors",
  "Utah Jazz": "nba_jazz",
  "UTA Jazz": "nba_jazz",
  "Washington Wizards": "nba_wizards",
  "WAS Wizards": "nba_wizards",
  "Arizona Cardinals": "nfl_cardinals",
  "ARZ Cardinals": "nfl_cardinals",
  "ARI Cardinals": "nfl_cardinals",
  "Atlanta Falcons": "nfl_falcons",
  "ATL Falcons": "nfl_falcons",
  "Baltimore Ravens": "nfl_ravens",
  "BLT Ravens": "nfl_ravens",
  "BAL Ravens": "nfl_ravens",
  Ravens: "nfl_ravens",
  "BUF Bills": "nfl_bills",
  Bills: "nfl_bills",
  "Buffalo Bills": "nfl_bills",
  "Carolina Panthers": "nfl_panthers",
  "CAR Panthers": "nfl_panthers",
  "Chicago Bears": "nfl_bears",
  "CHI Bears": "nfl_bears",
  "Cincinnati Bengals": "nfl_bengals",
  "CIN Bengals": "nfl_bengals",
  "Cleveland Browns": "nfl_browns",
  "CLE Browns": "nfl_browns",
  "CLV Browns": "nfl_browns",
  Browns: "nfl_browns",
  "Dallas Cowboys": "nfl_cowboys",
  "DAL Cowboys": "nfl_cowboys",
  "Denver Broncos": "nfl_broncos",
  "DEN Broncos": "nfl_broncos",
  "Detroit Lions": "nfl_lions",
  "DET Lions": "nfl_lions",
  "Green Bay Packers": "nfl_packers",
  "GB Packers": "nfl_packers",
  Packers: "nfl_packers",
  "Houston Texans": "nfl_texans",
  "HOU Texans": "nfl_texans",
  "HST Texans": "nfl_texans",
  "Indianapolis Colts": "nfl_colts",
  "IND Colts": "nfl_colts",
  Colts: "nfl_colts",
  "Jacksonville Jaguars": "nfl_jaguars",
  "JAX Jaguars": "nfl_jaguars",
  "JAC Jaguars": "nfl_jaguars",
  "Kansas City Chiefs": "nfl_chiefs",
  Chiefs: "nfl_chiefs",
  "KC Chiefs": "nfl_chiefs",
  "Las Vegas Raiders": "nfl_raiders",
  "LV Raiders": "nfl_raiders",
  "Los Angeles Chargers": "nfl_chargers",
  "LAC Chargers": "nfl_chargers",
  "LA Chargers": "nfl_chargers",
  Chargers: "nfl_chargers",
  "Los Angeles Rams": "nfl_rams",
  "LA Rams": "nfl_rams",
  "LAR Rams": "nfl_rams",
  "Miami Dolphins": "nfl_dolphins",
  "MIA Dolphins": "nfl_dolphins",
  Dolphins: "nfl_dolphins",
  "Minnesota Vikings": "nfl_vikings",
  "MIN Vikings": "nfl_vikings",
  Vikings: "nfl_vikings",
  "New England Patriots": "nfl_patriots",
  "NE Patriots": "nfl_patriots",
  Patriots: "nfl_patriots",
  "New Orleans Saints": "nfl_saints",
  "NO Saints": "nfl_saints",
  Saints: "nfl_saints",
  "New York Giants": "nfl_giants",
  "NYG Giants": "nfl_giants",
  "NY Giants": "nfl_giants",
  "New York Jets": "nfl_jets",
  "NYJ Jets": "nfl_jets",
  "NY Jets": "nfl_jets",
  Jets: ["nfl_jets", "nhl_jets"],
  "Philadelphia Eagles": "nfl_eagles",
  "PHI Eagles": "nfl_eagles",
  "PHL Eagles": "nfl_eagles",
  "Pittsburgh Steelers": "nfl_steelers",
  "PIT Steelers": "nfl_steelers",
  Steelers: "nfl_steelers",
  "San Francisco 49ers": "nfl_49ers",
  "SF 49ers": "nfl_49ers",
  "49ers": "nfl_49ers",
  "Seattle Seahawks": "nfl_seahawks",
  "SEA Seahawks": "nfl_seahawks",
  "Tampa Bay Buccaneers": "nfl_buccaneers",
  "TB Buccaneers": "nfl_buccaneers",
  "Tennessee Titans": "nfl_titans",
  "TEN Titans": "nfl_titans",
  Titans: "nfl_titans",
  "Washington Commanders": "nfl_commanders",
  "WAS Commanders": "nfl_commanders",
  Commanders: "nfl_commanders",
  "Chicago Sky": "wnba_sky",
  "CHI Sky": "wnba_sky",
  Sky: "wnba_sky",
  "CON Sun": "wnba_sun",
  "DAL Wings": "wnba_wings",
  "Indiana Fever": "wnba_fever",
  Fever: "wnba_fever",
  "IND Fever": "wnba_fever",
  "Las Vegas Aces": "wnba_aces",
  "LV Aces": "wnba_aces",
  Aces: "wnba_aces",
  "LA Sparks": "wnba_sparks",
  "MIN Lynx": "wnba_lynx",
  Lynx: "wnba_lynx",
  "New York Liberty": "wnba_liberty",
  "NY Liberty": "wnba_liberty",
  "NYL Liberty": "wnba_liberty",
  "Phoenix Mercury": "wnba_mercury",
  "University of Illinois": "ncaaf_illinois",
  "University of Illinois Fighting Illini": "ncaaf_illinois",
  Illinois: "ncaaf_illinois",
  "Illinois Fighting Illini": "ncaaf_illinois",
  "Fighting Illini": "ncaaf_illinois",

  Iowa: "ncaaf_iowa",
  "University of Iowa": "ncaaf_iowa",
  "University of Iowa Hawkeyes": "ncaaf_iowa",
  "Iowa Hawkeyes": "ncaaf_iowa",
  Hawkeyes: "ncaaf_iowa",

  Minnesota: "ncaaf_minnesota",
  "University of Minnesota": "ncaaf_minnesota",
  "University of Minnesota Golden Gophers": "ncaaf_minnesota",
  "Minnesota Golden Gophers": "ncaaf_minnesota",
  "Golden Gophers": "ncaaf_minnesota",

  Nebraska: "ncaaf_nebraska",
  "University of Nebraska": "ncaaf_nebraska",
  "University of Nebraska Cornhuskers": "ncaaf_nebraska",
  "Nebraska Cornhuskers": "ncaaf_nebraska",
  Cornhuskers: "ncaaf_nebraska",

  Northwestern: "ncaaf_northwestern",
  "Northwestern University": "ncaaf_northwestern",
  "Northwestern University Wildcats": "ncaaf_northwestern",
  "Northwestern Wildcats": "ncaaf_northwestern",
  Wildcats: "ncaaf_northwestern",

  Purdue: "ncaaf_purdue",
  "Purdue University": "ncaaf_purdue",
  "Purdue University Boilermakers": "ncaaf_purdue",
  "Purdue Boilermakers": "ncaaf_purdue",
  Boilermakers: "ncaaf_purdue",

  Wisconsin: "ncaaf_wisconsin",
  "University of Wisconsin": "ncaaf_wisconsin",
  "University of Wisconsin Badgers": "ncaaf_wisconsin",
  "Wisconsin Badgers": "ncaaf_wisconsin",
  Badgers: "ncaaf_wisconsin",

  Indiana: "ncaaf_indiana",
  "Indiana University": "ncaaf_indiana",
  "Indiana University Hoosiers": "ncaaf_indiana",
  "Indiana Hoosiers": "ncaaf_indiana",
  Hoosiers: "ncaaf_indiana",

  Maryland: "ncaaf_maryland",
  "University of Maryland": "ncaaf_maryland",
  "University of Maryland Terrapins": "ncaaf_maryland",
  "Maryland Terrapins": "ncaaf_maryland",
  Terrapins: "ncaaf_maryland",

  "Michigan State": "ncaaf_michigan_state",
  "Michigan State University": "ncaaf_michigan_state",
  "Michigan State University Spartans": "ncaaf_michigan_state",
  "Michigan State Spartans": "ncaaf_michigan_state",
  Spartans: "ncaaf_michigan_state",

  Michigan: "ncaaf_michigan",
  "University of Michigan": "ncaaf_michigan",
  "University of Michigan Wolverines": "ncaaf_michigan",
  "Michigan Wolverines": "ncaaf_michigan",
  Wolverines: "ncaaf_michigan",

  "Ohio State": "ncaaf_ohio_state",
  "The Ohio State University": "ncaaf_ohio_state",
  "The Ohio State University Buckeyes": "ncaaf_ohio_state",
  "Ohio State Buckeyes": "ncaaf_ohio_state",
  Buckeyes: "ncaaf_ohio_state",

  "Penn State": "ncaaf_penn_state",
  "Pennsylvania State University": "ncaaf_penn_state",
  "Pennsylvania State University Nittany Lions": "ncaaf_penn_state",
  "Penn State Nittany Lions": "ncaaf_penn_state",
  "Nittany Lions": "ncaaf_penn_state",

  Rutgers: "ncaaf_rutgers",
  "Rutgers University": "ncaaf_rutgers",
  "Rutgers University Scarlet Knights": "ncaaf_rutgers",
  "Rutgers Scarlet Knights": "ncaaf_rutgers",
  "Scarlet Knights": "ncaaf_rutgers",

  "Boston College": "ncaaf_boston_college",
  "Boston College Eagles": "ncaaf_boston_college",
  BC: "ncaaf_boston_college",
  "BC Eagles": "ncaaf_boston_college",
  Eagles: "ncaaf_boston_college",

  Clemson: "ncaaf_clemson",
  "Clemson Tigers": "ncaaf_clemson",

  Duke: "ncaaf_duke",
  "Duke Blue Devils": "ncaaf_duke",
  "Blue Devils": "ncaaf_duke",

  "Florida State": "ncaaf_florida_state",
  "Florida State Seminoles": "ncaaf_florida_state",
  FSU: "ncaaf_florida_state",
  "FSU Seminoles": "ncaaf_florida_state",
  Seminoles: "ncaaf_florida_state",

  "Georgia Tech": "ncaaf_georgia_tech",
  "Georgia Tech Yellow Jackets": "ncaaf_georgia_tech",
  "Yellow Jackets": "ncaaf_georgia_tech",

  Louisville: "ncaaf_louisville",
  "Louisville Cardinals": "ncaaf_louisville",

  Miami: "ncaaf_miami",
  "Miami Florida": "ncaaf_miami",
  "University of Miami": "ncaaf_miami",
  "Miami Hurricanes": "ncaaf_miami",
  "Miami (FL) Hurricanes": "ncaaf_miami",
  "Miami (FL)": "ncaaf_miami",
  "Miami FL": "ncaaf_miami",
  Hurricanes: "ncaaf_miami",

  "NC State": "ncaaf_nc_state",
  "North Carolina State University": "ncaaf_nc_state",
  "NC State Wolfpack": "ncaaf_nc_state",
  "North Carolina State Wolfpack": "ncaaf_nc_state",
  Wolfpack: "ncaaf_nc_state",

  "North Carolina": "ncaaf_north_carolina",
  "University of North Carolina": "ncaaf_north_carolina",
  "North Carolina Tar Heels": "ncaaf_north_carolina",
  "Tar Heels": "ncaaf_north_carolina",

  Pittsburgh: "ncaaf_pittsburgh",
  "University of Pittsburgh": "ncaaf_pittsburgh",
  "Pittsburgh Panthers": "ncaaf_pittsburgh",

  Syracuse: "ncaaf_syracuse",
  "Syracuse University": "ncaaf_syracuse",
  "Syracuse Orange": "ncaaf_syracuse",
  Orange: "ncaaf_syracuse",

  Virginia: "ncaaf_virginia",
  "University of Virginia": "ncaaf_virginia",
  "Virginia Cavaliers": "ncaaf_virginia",
  Cavaliers: "ncaaf_virginia",

  "Virginia Tech": "ncaaf_virginia_tech",
  "Virginia Tech Hokies": "ncaaf_virginia_tech",
  Hokies: "ncaaf_virginia_tech",

  "Wake Forest": "ncaaf_wake_forest",
  "Wake Forest University": "ncaaf_wake_forest",
  "Wake Forest Demon Deacons": "ncaaf_wake_forest",
  "Demon Deacons": "ncaaf_wake_forest",

  Charlotte: "ncaaf_charlotte",
  "Charlotte 49ers": "ncaaf_charlotte",
  "UNC Charlotte": "ncaaf_charlotte",
  "UNC Char.": "ncaaf_charlotte",
  "Charlotte University 49ers": "ncaaf_charlotte",

  "East Carolina": "ncaaf_east_carolina",
  "East Carolina Pirates": "ncaaf_east_carolina",
  ECU: "ncaaf_east_carolina",
  "ECU Pirates": "ncaaf_east_carolina",

  "Florida Atlantic": "ncaaf_florida_atlantic",
  "Fla. Atlantic": "ncaaf_florida_atlantic",
  "Florida Atlantic Owls": "ncaaf_florida_atlantic",
  FAU: "ncaaf_florida_atlantic",
  "FAU Owls": "ncaaf_florida_atlantic",
  Owls: "ncaaf_florida_atlantic",

  Memphis: "ncaaf_memphis",
  "University of Memphis": "ncaaf_memphis",
  "Memphis Tigers": "ncaaf_memphis",

  "North Texas": "ncaaf_north_texas",
  "University of North Texas": "ncaaf_north_texas",
  "North Texas Mean Green": "ncaaf_north_texas",
  "Mean Green": "ncaaf_north_texas",

  Rice: "ncaaf_rice",
  "Rice Owls": "ncaaf_rice",

  SMU: "ncaaf_smu",
  "Southern Methodist University": "ncaaf_smu",
  "SMU Mustangs": "ncaaf_smu",
  Mustangs: "ncaaf_smu",

  "South Florida": "ncaaf_south_florida",
  "University of South Florida": "ncaaf_south_florida",
  "South Florida Bulls": "ncaaf_south_florida",
  Bulls: "ncaaf_south_florida",

  Temple: "ncaaf_temple",
  "Temple University": "ncaaf_temple",
  "Temple Owls": "ncaaf_temple",

  Tulane: "ncaaf_tulane",
  "Tulane University": "ncaaf_tulane",
  "Tulane Green Wave": "ncaaf_tulane",
  "Green Wave": "ncaaf_tulane",

  Tulsa: "ncaaf_tulsa",
  "University of Tulsa": "ncaaf_tulsa",
  "Tulsa Golden Hurricane": "ncaaf_tulsa",
  "Golden Hurricane": "ncaaf_tulsa",

  UAB: "ncaaf_uab",
  "University of Alabama at Birmingham": "ncaaf_uab",
  "UAB Blazers": "ncaaf_uab",
  Blazers: "ncaaf_uab",

  UTSA: "ncaaf_utsa",
  "University of Texas at San Antonio": "ncaaf_utsa",
  "UTSA Roadrunners": "ncaaf_utsa",
  Roadrunners: "ncaaf_utsa",

  Navy: "ncaaf_navy",
  "United States Naval Academy": "ncaaf_navy",
  "Navy Midshipmen": "ncaaf_navy",
  Midshipmen: "ncaaf_navy",

  BYU: "ncaaf_byu",
  "Brigham Young University": "ncaaf_byu",
  "BYU Cougars": "ncaaf_byu",
  Cougars: "ncaaf_byu",

  Baylor: "ncaaf_baylor",
  "Baylor University": "ncaaf_baylor",
  "Baylor Bears": "ncaaf_baylor",
  Bears: "ncaaf_baylor",

  Cincinnati: "ncaaf_cincinnati",
  "University of Cincinnati": "ncaaf_cincinnati",
  "Cincinnati Bearcats": "ncaaf_cincinnati",
  Bearcats: "ncaaf_cincinnati",

  Houston: "ncaaf_houston",
  "University of Houston": "ncaaf_houston",
  "Houston Cougars": "ncaaf_houston",

  "Iowa State": "ncaaf_iowa_state",
  "Iowa State University": "ncaaf_iowa_state",
  "Iowa State Cyclones": "ncaaf_iowa_state",
  Cyclones: "ncaaf_iowa_state",

  Kansas: "ncaaf_kansas",
  "University of Kansas": "ncaaf_kansas",
  "Kansas Jayhawks": "ncaaf_kansas",
  Jayhawks: "ncaaf_kansas",

  "Wichita St": "ncaaf_wichita",
  "Wichita State": "ncaaf_wichita",
  "Wichita State Shockers": "ncaaf_wichita",
  Shockers: "ncaaf_kansas",

  "Kennesaw St.": "ncaaf_kennesaw",
  "Kennesaw State": "ncaaf_kennesaw",
  "Kennesaw State Owls": "ncaaf_kennesaw",
  "Eastern Ky.": "ncaaf_eastern_ky",
  "Eastern Kentucky": "ncaaf_eastern_ky",
  "Eastern Kentucky Colonels": "ncaaf_eastern_ky",
  "Stetson": "ncaaf_stetson",
  "Stetson Hatters": "ncaaf_stetson",
  "Lipscomb": "ncaaf_lipscomb",
  "Lipscomb Bisons": "ncaaf_lipscomb",
  "North Florida": "ncaaf_north_florida",
  "North Florida Ospreys": "ncaaf_north_florida",
  "Central Ark.": "ncaaf_central_ark",
  "Central Arkansas": "ncaaf_central_ark",
  "Central Arkansas Bears": "ncaaf_central_ark",
  "Austin Peay": "ncaaf_austin_peay",
  "Austin Peay Governors": "ncaaf_austin_peay",
  "North Ala.": "ncaaf_north_ala",
  "North Alabama": "ncaaf_north_ala",
  "North Alabama Lions": "ncaaf_north_ala",
  "Queens (NC)": "ncaaf_queens_nc",
  "Queens University of Charlotte": "ncaaf_queens_nc",
  "FGCU": "ncaaf_fgcu",
  "Florida Gulf Coast": "ncaaf_fgcu",
  "Florida Gulf Coast Eagles": "ncaaf_fgcu",
  "Jacksonville": "ncaaf_jacksonville",
  "Jacksonville Dolphins": "ncaaf_jacksonville",
  "Bellarmine": "ncaaf_bellarmine",

  
  "UMass Lowell": "ncaaf_umass_lowell",
  "UMass Lowell River Hawks": "ncaaf_umass_lowell",
  "Vermont": "ncaaf_vermont",
  "Vermont Catamounts": "ncaaf_vermont",
  "Bryant": "ncaaf_bryant",
  "Bryant Bulldogs": "ncaaf_bryant",
  "UAlbany": "ncaaf_ualbany",
  "UAlbany Great Danes": "ncaaf_ualbany",
  "New Hampshire": "ncaaf_new_hampshire",
  "New Hampshire Wildcats": "ncaaf_new_hampshire",
  "Binghamton": "ncaaf_binghamton",
  "Binghamton Bearcats": "ncaaf_binghamton",
  "Maine": "ncaaf_maine",
  "Maine Black Bears": "ncaaf_maine",
  "UMBC": "ncaaf_umbc",
  "UMBC Retrievers": "ncaaf_umbc",
  "NJIT": "ncaaf_njit",
  "NJIT Highlanders": "ncaaf_njit",

    "Dayton": "ncaaf_dayton",
    "Dayton Flyers": "ncaaf_dayton",
    "Richmond": "ncaaf_richmond",
    "Richmond Spiders": "ncaaf_richmond",
    "Rhode Island": "ncaaf_rhode_island",
    "Rhode Island Rams": "ncaaf_rhode_island",
    "Loyola Chicago": "ncaaf_loyola_chicago",
    "Loyola Chicago Ramblers": "ncaaf_loyola_chicago",
    "George Washington": "ncaaf_george_washington",
    "George Washington Colonials": "ncaaf_george_washington",
    "Fordham": "ncaaf_fordham",
    "Fordham Rams": "ncaaf_fordham",
    "George Mason": "ncaaf_george_mason",
    "George Mason Patriots": "ncaaf_george_mason",
    "Massachusetts": "ncaaf_massachusetts",
    "Massachusetts Minutemen": "ncaaf_massachusetts",
    "VCU": "ncaaf_vcu",
    "VCU Rams": "ncaaf_vcu",
    "St. Bonaventure": "ncaaf_st_bonaventure",
    "St. Bonaventure Bonnies": "ncaaf_st_bonaventure",
    "Saint Louis": "ncaaf_saint_louis",
    "Saint Louis Billikens": "ncaaf_saint_louis",
    "La Salle": "ncaaf_la_salle",
    "La Salle Explorers": "ncaaf_la_salle",
    "Saint Joseph's": "ncaaf_saint_josephs",
    "Saint Joseph's Hawks": "ncaaf_saint_josephs",
    "Davidson": "ncaaf_davidson",
    "Davidson Wildcats": "ncaaf_davidson",
    "Duquesne": "ncaaf_duquesne",
    "Duquesne Dukes": "ncaaf_duquesne",

    "UConn": "ncaaf_uconn",
    "UConn Huskies": "ncaaf_uconn",
    "Seton Hall": "ncaaf_seton_hall",
    "Seton Hall Pirates": "ncaaf_seton_hall",
    "Villanova": "ncaaf_villanova",
    "Villanova Wildcats": "ncaaf_villanova",
    "Creighton": "ncaaf_creighton",
    "Creighton Bluejays": "ncaaf_creighton",
    "St. John's (NY)": "ncaaf_st_johns_ny",
    "St. John's Red Storm": "ncaaf_st_johns_ny",
    "Marquette": "ncaaf_marquette",
    "Marquette Golden Eagles": "ncaaf_marquette",
    "Xavier": "ncaaf_xavier",
    "Xavier Musketeers": "ncaaf_xavier",
    "Butler": "ncaaf_butler",
    "Butler Bulldogs": "ncaaf_butler",
    "Providence": "ncaaf_providence",
    "Providence Friars": "ncaaf_providence",
    "Georgetown": "ncaaf_georgetown",
    "Georgetown Hoyas": "ncaaf_georgetown",
    "DePaul": "ncaaf_depaul",
    "DePaul Blue Demons": "ncaaf_depaul",

  "Eastern Wash.": "ncaaf_eastern_wash",
  "Eastern Washington": "ncaaf_eastern_wash",
  "Eastern Washington Eagles": "ncaaf_eastern_wash",
  "Montana St.": "ncaaf_montana_st",
  "Montana State": "ncaaf_montana_st",
  "Montana State Bobcats": "ncaaf_montana_st",
  "Northern Colo.": "ncaaf_northern_colo",
  "Northern Colorado": "ncaaf_northern_colo",
  "Northern Colorado Bears": "ncaaf_northern_colo",
  "Montana": "ncaaf_montana",
  "Montana Grizzlies": "ncaaf_montana",
  "Weber St.": "ncaaf_weber_st",
  "Weber State": "ncaaf_weber_st",
  "Weber State Wildcats": "ncaaf_weber_st",
  "Portland St.": "ncaaf_portland_st",
  "Portland State": "ncaaf_portland_st",
  "Portland State Vikings": "ncaaf_portland_st",
  "Sacramento St.": "ncaaf_sacramento_st",
  "Sacramento State": "ncaaf_sacramento_st",
  "Sacramento State Hornets": "ncaaf_sacramento_st",
  "Idaho": "ncaaf_idaho",
  "Idaho Vandals": "ncaaf_idaho",
  "Idaho St.": "ncaaf_idaho_st",
  "Idaho State": "ncaaf_idaho_st",
  "Idaho State Bengals": "ncaaf_idaho_st",
  "Northern Ariz.": "ncaaf_northern_ariz",
  "Northern Arizona": "ncaaf_northern_ariz",
  "Northern Arizona Lumberjacks": "ncaaf_northern_ariz",

  "High Point": "ncaaf_high_point",
  "High Point Panthers": "ncaaf_high_point",
  "Winthrop": "ncaaf_winthrop",
  "Winthrop Eagles": "ncaaf_winthrop",
  "UNC Asheville": "ncaaf_unc_asheville",
  "UNC Asheville Bulldogs": "ncaaf_unc_asheville",
  "Charleston So.": "ncaaf_charleston_so",
  "Charleston Southern": "ncaaf_charleston_so",
  "Charleston Southern Buccaneers": "ncaaf_charleston_so",
  "Radford": "ncaaf_radford",
  "Radford Highlanders": "ncaaf_radford",
  "Gardner-Webb": "ncaaf_gardner_webb",
  "Gardner-Webb Bulldogs": "ncaaf_gardner_webb",
  "Longwood": "ncaaf_longwood",
  "Longwood Lancers": "ncaaf_longwood",
  "Presbyterian": "ncaaf_presbyterian",
  "Presbyterian Blue Hose": "ncaaf_presbyterian",
  "USC Upstate": "ncaaf_usc_upstate",
  "USC Upstate Spartans": "ncaaf_usc_upstate",

"UC Irvine": "ncaaf_uc_irvine",
"UC Irvine Anteaters": "ncaaf_uc_irvine",
"UC San Diego": "ncaaf_uc_san_diego",
"UC San Diego Tritons": "ncaaf_uc_san_diego",
"UC Davis": "ncaaf_uc_davis",
"UC Davis Aggies": "ncaaf_uc_davis",
"CSUN": "ncaaf_csun",
"CSUN Matadors": "ncaaf_csun",
"UC Santa Barbara": "ncaaf_uc_santa_barbara",
"UC Santa Barbara Gauchos": "ncaaf_uc_santa_barbara",
"Long Beach St.": "ncaaf_long_beach_st",
"Long Beach State": "ncaaf_long_beach_st",
"Long Beach State Beach": "ncaaf_long_beach_st",
"Hawaii": "ncaaf_hawaii",
"Hawaii Rainbow Warriors": "ncaaf_hawaii",
"UC Riverside": "ncaaf_uc_riverside",
"UC Riverside Highlanders": "ncaaf_uc_riverside",
"Cal St. Fullerton": "ncaaf_cal_st_fullerton",
"Cal State Fullerton": "ncaaf_cal_st_fullerton",
"Cal State Fullerton Titans": "ncaaf_cal_st_fullerton",
"CSU Bakersfield": "ncaaf_csu_bakersfield",
"CSU Bakersfield Roadrunners": "ncaaf_csu_bakersfield",
"Cal Poly": "ncaaf_cal_poly",
"Cal Poly Mustangs": "ncaaf_cal_poly",

"Col. of Charleston": "ncaaf_col_charleston",
"College of Charleston Cougars": "ncaaf_col_charleston",
"Drexel": "ncaaf_drexel",
"Drexel Dragons": "ncaaf_drexel",
"UNCW": "ncaaf_uncw",
"UNC Wilmington Seahawks": "ncaaf_uncw",
"Delaware": "ncaaf_delaware",
"Delaware Fightin' Blue Hens": "ncaaf_delaware",
"Stony Brook": "ncaaf_stony_brook",
"Stony Brook Seawolves": "ncaaf_stony_brook",
"Monmouth": "ncaaf_monmouth",
"Monmouth Hawks": "ncaaf_monmouth",
"Towson": "ncaaf_towson",
"Towson Tigers": "ncaaf_towson",
"Campbell": "ncaaf_campbell",
"Campbell Fighting Camels": "ncaaf_campbell",
"William & Mary": "ncaaf_william_mary",
"William & Mary Tribe": "ncaaf_william_mary",
"Northeastern": "ncaaf_northeastern",
"Northeastern Huskies": "ncaaf_northeastern",
"N.C. A&T": "ncaaf_ncat",
"N.C. A&T Aggies": "ncaaf_ncat",
"Elon": "ncaaf_elon",
"Elon Phoenix": "ncaaf_elon",
"Hofstra": "ncaaf_hofstra",
"Hofstra Pride": "ncaaf_hofstra",
"Hampton": "ncaaf_hampton",
"Hampton Pirates": "ncaaf_hampton",

"Oakland": "ncaaf_oakland",
"Oakland Golden Grizzlies": "ncaaf_oakland",
"Green Bay": "ncaaf_green_bay",
"Green Bay Phoenix": "ncaaf_green_bay",
"Youngstown St.": "ncaaf_youngstown_st",
"Youngstown State Penguins": "ncaaf_youngstown_st",
"Milwaukee": "ncaaf_milwaukee",
"Milwaukee Panthers": "ncaaf_milwaukee",
"Purdue Fort Wayne": "ncaaf_purdue_fort_wayne",
"Purdue Fort Wayne Mastodons": "ncaaf_purdue_fort_wayne",
"Wright St.": "ncaaf_wright_st",
"Wright State Raiders": "ncaaf_wright_st",
"Northern Ky.": "ncaaf_northern_ky",
"Northern Kentucky Norse": "ncaaf_northern_ky",
"Cleveland St.": "ncaaf_cleveland_st",
"Cleveland State Vikings": "ncaaf_cleveland_st",
"Robert Morris": "ncaaf_robert_morris",
"Robert Morris Colonials": "ncaaf_robert_morris",
"IUPUI": "ncaaf_iupui",
"IUPUI Jaguars": "ncaaf_iupui",
"Detroit Mercy": "ncaaf_detroit_mercy",
"Detroit Mercy Titans": "ncaaf_detroit_mercy",

"Saint Peter's": "ncaaf_saint_peters",
"Saint Peter's Peacocks": "ncaaf_saint_peters",
"Quinnipiac": "ncaaf_quinnipiac",
"Quinnipiac Bobcats": "ncaaf_quinnipiac",
"Marist": "ncaaf_marist",
"Marist Red Foxes": "ncaaf_marist",
"Fairfield": "ncaaf_fairfield",
"Fairfield Stags": "ncaaf_fairfield",
"Niagara": "ncaaf_niagara",
"Niagara Purple Eagles": "ncaaf_niagara",
"Canisius": "ncaaf_canisius",
"Canisius Golden Griffins": "ncaaf_canisius",
"Iona": "ncaaf_iona",
"Iona Gaels": "ncaaf_iona",
"Mount St. Mary's": "ncaaf_mount_st_marys",
"Mount St. Mary's Mountaineers": "ncaaf_mount_st_marys",
"Rider": "ncaaf_rider",
"Rider Broncs": "ncaaf_rider",
"Siena": "ncaaf_siena",
"Siena Saints": "ncaaf_siena",
"Manhattan": "ncaaf_manhattan",
"Manhattan Jaspers": "ncaaf_manhattan",

"N.C. Central": "ncaaf_nc_central",
"N.C. Central Eagles": "ncaaf_nc_central",
"Delaware St.": "ncaaf_delaware_st",
"Delaware State Hornets": "ncaaf_delaware_st",
"Howard": "ncaaf_howard",
"Howard Bison": "ncaaf_howard",
"Norfolk St.": "ncaaf_norfolk_st",
"Norfolk State Spartans": "ncaaf_norfolk_st",
"Coppin St.": "ncaaf_coppin_st",
"Coppin State Eagles": "ncaaf_coppin_st",
"UMES": "ncaaf_umes",
"UMES Hawks": "ncaaf_umes",
"South Carolina St.": "ncaaf_south_carolina_st",
"South Carolina State Bulldogs": "ncaaf_south_carolina_st",
"Morgan St.": "ncaaf_morgan_st",
"Morgan State Bears": "ncaaf_morgan_st",

"Indiana St.": "ncaaf_indiana_st",
"Indiana State Sycamores": "ncaaf_indiana_st",
"Drake": "ncaaf_drake",
"Drake Bulldogs": "ncaaf_drake",
"Bradley": "ncaaf_bradley",
"Bradley Braves": "ncaaf_bradley",
"Southern Ill.": "ncaaf_southern_ill",
"Southern Illinois Salukis": "ncaaf_southern_ill",
"Belmont": "ncaaf_belmont",
"Belmont Bruins": "ncaaf_belmont",
"Murray St.": "ncaaf_murray_st",
"Murray State Racers": "ncaaf_murray_st",
"UNI": "ncaaf_uni",
"Northern Iowa Panthers": "ncaaf_uni",
"Missouri St.": "ncaaf_missouri_st",
"Missouri State Bears": "ncaaf_missouri_st",
"Illinois St.": "ncaaf_illinois_st",
"Illinois State Redbirds": "ncaaf_illinois_st",
"Evansville": "ncaaf_evansville",
"Evansville Purple Aces": "ncaaf_evansville",
"UIC": "ncaaf_uic",
"UIC Flames": "ncaaf_uic",
"Valparaiso": "ncaaf_valparaiso",
"Valparaiso Crusaders": "ncaaf_valparaiso",

"Central Conn. St.": "ncaaf_central_conn_st",
"Central Connecticut State Blue Devils": "ncaaf_central_conn_st",
"Merrimack": "ncaaf_merrimack",
"Merrimack Warriors": "ncaaf_merrimack",
"Sacred Heart": "ncaaf_sacred_heart",
"Sacred Heart Pioneers": "ncaaf_sacred_heart",
"LIU": "ncaaf_liu",
"LIU Sharks": "ncaaf_liu",
"Wagner": "ncaaf_wagner",
"Wagner Seahawks": "ncaaf_wagner",
"Le Moyne": "ncaaf_le_moyne",
"Le Moyne Dolphins": "ncaaf_le_moyne",
"FDU": "ncaaf_fdu",
"FDU Knights": "ncaaf_fdu",
"Saint Francis (PA)": "ncaaf_saint_francis_pa",
"Saint Francis (PA) Red Flash": "ncaaf_saint_francis_pa",
"Stonehill": "ncaaf_stonehill",
"Stonehill Skyhawks": "ncaaf_stonehill",

"Western Ill.": "ncaaf_western_ill",
"Western Illinois Leathernecks": "ncaaf_western_ill",
"Morehead St.": "ncaaf_morehead_st",
"Morehead State Eagles": "ncaaf_morehead_st",
"UT Martin": "ncaaf_ut_martin",
"UT Martin Skyhawks": "ncaaf_ut_martin",
"SIUE": "ncaaf_siue",
"SIUE Cougars": "ncaaf_siue",
"Tennessee St.": "ncaaf_tennessee_st",
"Tennessee State Tigers": "ncaaf_tennessee_st",
"Little Rock": "ncaaf_little_rock",
"Little Rock Trojans": "ncaaf_little_rock",
"Eastern Ill.": "ncaaf_eastern_ill",
"Eastern Illinois Panthers": "ncaaf_eastern_ill",
"Tennessee Tech": "ncaaf_tennessee_tech",
"Tennessee Tech Golden Eagles": "ncaaf_tennessee_tech",
"Southern Ind.": "ncaaf_southern_ind",
"Southern Indiana Screaming Eagles": "ncaaf_southern_ind",
"Lindenwood": "ncaaf_lindenwood",
"Lindenwood Lions": "ncaaf_lindenwood",
"Southeast Mo. St.": "ncaaf_southeast_mo_st",
"Southeast Missouri State Redhawks": "ncaaf_southeast_mo_st",

"Lafayette": "ncaaf_lafayette",
"Lafayette Leopards": "ncaaf_lafayette",
"American": "ncaaf_american",
"American Eagles": "ncaaf_american",
"Colgate": "ncaaf_colgate",
"Colgate Raiders": "ncaaf_colgate",
"Boston U.": "ncaaf_boston_u",
"Boston University Terriers": "ncaaf_boston_u",
"Bucknell": "ncaaf_bucknell",
"Bucknell Bison": "ncaaf_bucknell",
"Army West Point": "ncaaf_army_west_point",
"Army West Point Black Knights": "ncaaf_army_west_point",
"Lehigh": "ncaaf_lehigh",
"Lehigh Mountain Hawks": "ncaaf_lehigh",
"Holy Cross": "ncaaf_holy_cross",
"Holy Cross Crusaders": "ncaaf_holy_cross",
"Loyola Maryland": "ncaaf_loyola_maryland",
"Loyola Maryland Greyhounds": "ncaaf_loyola_maryland",

"Samford": "ncaaf_samford",
"Samford Bulldogs": "ncaaf_samford",
"Western Caro.": "ncaaf_western_caro",
"Western Carolina Catamounts": "ncaaf_western_caro",
"UNC Greensboro": "ncaaf_unc_greensboro",
"UNC Greensboro Spartans": "ncaaf_unc_greensboro",
"Wofford": "ncaaf_wofford",
"Wofford Terriers": "ncaaf_wofford",
"Chattanooga": "ncaaf_chattanooga",
"Chattanooga Mocs": "ncaaf_chattanooga",
"Furman": "ncaaf_furman",
"Furman Paladins": "ncaaf_furman",
"ETSU": "ncaaf_etsu",
"ETSU Buccaneers": "ncaaf_etsu",
"Mercer": "ncaaf_mercer",
"Mercer Bears": "ncaaf_mercer",
"The Citadel": "ncaaf_the_citadel",
"The Citadel Bulldogs": "ncaaf_the_citadel",
"VMI": "ncaaf_vmi",
"VMI Keydets": "ncaaf_vmi",

"Southern U.": "ncaaf_southern_u",
"Southern Jaguars": "ncaaf_southern_u",
"Jackson St.": "ncaaf_jackson_st",
"Jackson State Tigers": "ncaaf_jackson_st",
"Alabama St.": "ncaaf_alabama_st",
"Alabama State Hornets": "ncaaf_alabama_st",
"Grambling": "ncaaf_grambling",
"Grambling State Tigers": "ncaaf_grambling",
"Bethune-Cookman": "ncaaf_bethune_cookman",
"Bethune-Cookman Wildcats": "ncaaf_bethune_cookman",
"Alabama A&M": "ncaaf_alabama_am",
"Alabama A&M Bulldogs": "ncaaf_alabama_am",
"Ark.-Pine Bluff": "ncaaf_ark_pine_bluff",
"Arkansas-Pine Bluff Golden Lions": "ncaaf_ark_pine_bluff",
"Prairie View": "ncaaf_prairie_view",
"Prairie View A&M Panthers": "ncaaf_prairie_view",
"Texas Southern": "ncaaf_texas_southern",
"Texas Southern Tigers": "ncaaf_texas_southern",
"Alcorn": "ncaaf_alcorn",
"Alcorn State Braves": "ncaaf_alcorn",
"Florida A&M": "ncaaf_florida_am",
"Florida A&M Rattlers": "ncaaf_florida_am",
"Mississippi Val.": "ncaaf_mississippi_val",
"Mississippi Valley State Delta Devils": "ncaaf_mississippi_val",

"Princeton": "ncaaf_princeton",
"Princeton Tigers": "ncaaf_princeton",
"Cornell": "ncaaf_cornell",
"Cornell Big Red": "ncaaf_cornell",
"Yale": "ncaaf_yale",
"Yale Bulldogs": "ncaaf_yale",
"Penn": "ncaaf_penn",
"Penn Quakers": "ncaaf_penn",
"Columbia": "ncaaf_columbia",
"Columbia Lions": "ncaaf_columbia",
"Harvard": "ncaaf_harvard",
"Harvard Crimson": "ncaaf_harvard",
"Dartmouth": "ncaaf_dartmouth",
"Dartmouth Big Green": "ncaaf_dartmouth",
"Brown": "ncaaf_brown",
"Brown Bears": "ncaaf_brown",

"St. Thomas (MN)": "ncaaf_st_thomas_mn",
"St. Thomas Tommies": "ncaaf_st_thomas_mn",
"Omaha": "ncaaf_omaha",
"Omaha Mavericks": "ncaaf_omaha",
"Denver": "ncaaf_denver",
"Denver Pioneers": "ncaaf_denver",
"South Dakota St.": "ncaaf_south_dakota_st",
"South Dakota State": "ncaaf_south_dakota_st",
"Oral Roberts": "ncaaf_oral_roberts",
"Oral Roberts Golden Eagles": "ncaaf_oral_roberts",
"North Dakota St.": "ncaaf_north_dakota_st",
"North Dakota State Bison": "ncaaf_north_dakota_st",
"South Dakota": "ncaaf_south_dakota",
"South Dakota Coyotes": "ncaaf_south_dakota",
"North Dakota": "ncaaf_north_dakota",
"North Dakota Fighting Hawks": "ncaaf_north_dakota",
"Kansas City": "ncaaf_kansas_city",
"Kansas City Roos": "ncaaf_kansas_city",

"San Francisco": "ncaaf_san_francisco",
"San Francisco Dons": "ncaaf_san_francisco",
"Saint Mary's (CA)": "ncaaf_saint_marys_ca",
"Saint Mary's Gaels": "ncaaf_saint_marys_ca",
"Santa Clara": "ncaaf_santa_clara",
"Santa Clara Broncos": "ncaaf_santa_clara",
"Gonzaga": "ncaaf_gonzaga",
"Gonzaga Bulldogs": "ncaaf_gonzaga",
"Pepperdine": "ncaaf_pepperdine",
"Pepperdine Waves": "ncaaf_pepperdine",
"LMU (CA)": "ncaaf_lmu_ca",
"LMU Lions": "ncaaf_lmu_ca",
"Portland": "ncaaf_portland",
"Portland Pilots": "ncaaf_portland",
"San Diego": "ncaaf_san_diego",
"San Diego Toreros": "ncaaf_san_diego",
"Pacific": "ncaaf_pacific",
"Pacific Tigers": "ncaaf_pacific",

"Grand Canyon": "ncaaf_grand_canyon",
"Grand Canyon Antelopes": "ncaaf_grand_canyon",
"SFA": "ncaaf_sfa",
"SFA Lumberjacks": "ncaaf_sfa",
"Tarleton St.": "ncaaf_tarleton_st",
"Tarleton State Texans": "ncaaf_tarleton_st",
"Utah Tech": "ncaaf_utah_tech",
"Utah Tech Trailblazers": "ncaaf_utah_tech",
"Seattle U": "ncaaf_seattle_u",
"Seattle U Redhawks": "ncaaf_seattle_u",
"California Baptist": "ncaaf_california_baptist",
"California Baptist Lancers": "ncaaf_california_baptist",
"UT Arlington": "ncaaf_ut_arlington",
"UT Arlington Mavericks": "ncaaf_ut_arlington",
"Utah Valley": "ncaaf_utah_valley",
"Utah Valley Wolverines": "ncaaf_utah_valley",
"UTRGV": "ncaaf_utrgv",
"UTRGV Vaqueros": "ncaaf_utrgv",
"Abilene Christian": "ncaaf_abilene_christian",
"Abilene Christian Wildcats": "ncaaf_abilene_christian",
"Southern Utah": "ncaaf_southern_utah",
"Southern Utah Thunderbirds": "ncaaf_southern_utah",






  

  "Kansas State": "ncaaf_kansas_state",
  "Kansas State University": "ncaaf_kansas_state",
  "Kansas State Wildcats": "ncaaf_kansas_state",

  Oklahoma: "ncaaf_oklahoma",
  "University of Oklahoma": "ncaaf_oklahoma",
  "Oklahoma Sooners": "ncaaf_oklahoma",
  Sooners: "ncaaf_oklahoma",

  "Oklahoma State": "ncaaf_oklahoma_state",
  "Oklahoma State University": "ncaaf_oklahoma_state",
  "Oklahoma State Cowboys": "ncaaf_oklahoma_state",
  Cowboys: "ncaaf_oklahoma_state",

  TCU: "ncaaf_tcu",
  "Texas Christian University": "ncaaf_tcu",
  "TCU Horned Frogs": "ncaaf_tcu",
  "Horned Frogs": "ncaaf_tcu",

  Texas: "ncaaf_texas",
  "University of Texas": "ncaaf_texas",
  "Texas Longhorns": "ncaaf_texas",
  Longhorns: "ncaaf_texas",

  "Texas Tech": "ncaaf_texas_tech",
  "Texas Tech University": "ncaaf_texas_tech",
  "Texas Tech Red Raiders": "ncaaf_texas_tech",
  "Red Raiders": "ncaaf_texas_tech",

  UCF: "ncaaf_ucf",
  "University of Central Florida": "ncaaf_ucf",
  "Central Florida": "ncaaf_ucf",
  "UCF Knights": "ncaaf_ucf",
  Knights: "ncaaf_ucf",

  "West Virginia": "ncaaf_west_virginia",
  "West Virginia University": "ncaaf_west_virginia",
  "West Virginia Mountaineers": "ncaaf_west_virginia",
  "WV Mountaineers": "ncaaf_west_virginia",
  Mountaineers: "ncaaf_west_virginia",

  "Jacksonville State": "ncaaf_jacksonville_state",
  "Jacksonville State Gamecocks": "ncaaf_jacksonville_state",
  Gamecocks: "ncaaf_jacksonville_state",

  "Louisiana Tech": "ncaaf_louisiana_tech",
  "Louisiana Tech Bulldogs": "ncaaf_louisiana_tech",
  Bulldogs: "ncaaf_louisiana_tech",

  Liberty: "ncaaf_liberty",
  "Liberty University": "ncaaf_liberty",
  "Liberty Flames": "ncaaf_liberty",
  Flames: "ncaaf_liberty",

  "Middle Tennessee": "ncaaf_middle_tennessee",
  "Middle Tennessee State": "ncaaf_middle_tennessee",
  "Middle Tennessee Blue Raiders": "ncaaf_middle_tennessee",
  "Blue Raiders": "ncaaf_middle_tennessee",

  "Sam Houston": "ncaaf_sam_houston",
  "Sam Houston State": "ncaaf_sam_houston",
  "Sam Houston Bearkats": "ncaaf_sam_houston",
  "Sam Houston State Bearkats": "ncaaf_sam_houston",
  Bearkats: "ncaaf_sam_houston",

  "Western Kentucky": "ncaaf_western_kentucky",
  "Western Kentucky Hilltoppers": "ncaaf_western_kentucky",
  Hilltoppers: "ncaaf_western_kentucky",

  "New Mexico State": "ncaaf_new_mexico_state",
  "New Mexico State Aggies": "ncaaf_new_mexico_state",
  Aggies: "ncaaf_new_mexico_state",

  "Florida International": "ncaaf_florida_international",
  FIU: "ncaaf_florida_international",
  "Florida International Panthers": "ncaaf_florida_international",

  UTEP: "ncaaf_utep",
  "University of Texas at El Paso": "ncaaf_utep",
  "UTEP Miners": "ncaaf_utep",
  Miners: "ncaaf_utep",

  "University of Massachusetts": "ncaaf_massachusetts",
  UMass: "ncaaf_massachusetts",

  "Notre Dame": "ncaaf_notre_dame",
  "University of Notre Dame": "ncaaf_notre_dame",
  "Notre Dame Fighting Irish": "ncaaf_notre_dame",
  "Fighting Irish": "ncaaf_notre_dame",

  Army: "ncaaf_army",
  "United States Military Academy": "ncaaf_army",
  "Army Black Knights": "ncaaf_army",
  "Black Knights": "ncaaf_army",

  "University of Connecticut": "ncaaf_uconn",
  Connecticut: "ncaaf_uconn",
  "Connecticut Huskies": "ncaaf_uconn",
  Huskies: "ncaaf_uconn",

  Akron: "ncaaf_akron",
  "University of Akron": "ncaaf_akron",
  "Akron Zips": "ncaaf_akron",
  Zips: "ncaaf_akron",

  "Bowling Green": "ncaaf_bowling_green",
  "Bowling Green State University": "ncaaf_bowling_green",
  "Bowling Green Falcons": "ncaaf_bowling_green",
  Falcons: "ncaaf_bowling_green",

  Buffalo: "ncaaf_buffalo",
  "University at Buffalo": "ncaaf_buffalo",
  "Buffalo Bulls": "ncaaf_buffalo",

  "Kent State": "ncaaf_kent_state",
  "Kent State University": "ncaaf_kent_state",
  "Kent State Golden Flashes": "ncaaf_kent_state",
  "Golden Flashes": "ncaaf_kent_state",

  "Miami (OH)": "ncaaf_miami_oh",
  "Miami Ohio": "ncaaf_miami_oh",
  "Miami University": "ncaaf_miami_oh",
  "Miami RedHawks": "ncaaf_miami_oh",
  "Miami (OH) RedHawks": "ncaaf_miami_oh",
  RedHawks: "ncaaf_miami_oh",

  Ohio: "ncaaf_ohio",
  "Ohio University": "ncaaf_ohio",
  "Ohio Bobcats": "ncaaf_ohio",
  Bobcats: "ncaaf_ohio",

  "Ball State": "ncaaf_ball_state",
  "Ball State University": "ncaaf_ball_state",
  "Ball State Cardinals": "ncaaf_ball_state",

  "Central Michigan": "ncaaf_central_michigan",
  "Central Michigan University": "ncaaf_central_michigan",
  "Central Michigan Chippewas": "ncaaf_central_michigan",
  Chippewas: "ncaaf_central_michigan",

  "Eastern Michigan": "ncaaf_eastern_michigan",
  "Eastern Michigan University": "ncaaf_eastern_michigan",
  "Eastern Michigan Eagles": "ncaaf_eastern_michigan",

  "Northern Illinois": "ncaaf_northern_illinois",
  "Northern Illinois University": "ncaaf_northern_illinois",
  "Northern Illinois Huskies": "ncaaf_northern_illinois",

  Toledo: "ncaaf_toledo",
  "University of Toledo": "ncaaf_toledo",
  "Toledo Rockets": "ncaaf_toledo",
  Rockets: "ncaaf_toledo",

  "Western Michigan": "ncaaf_western_michigan",
  "Western Michigan University": "ncaaf_western_michigan",
  "Western Michigan Broncos": "ncaaf_western_michigan",
  Broncos: "ncaaf_western_michigan",

  "San Diego State": "ncaaf_san_diego_state",
  "San Diego State University": "ncaaf_san_diego_state",
  "San Diego State Aztecs": "ncaaf_san_diego_state",
  Aztecs: "ncaaf_san_diego_state",

  "Air Force": "ncaaf_air_force",
  "United States Air Force Academy": "ncaaf_air_force",
  "Air Force Falcons": "ncaaf_air_force",

  "Boise State": "ncaaf_boise_state",
  "Boise State University": "ncaaf_boise_state",
  "Boise State Broncos": "ncaaf_boise_state",

  "Colorado State": "ncaaf_colorado_state",
  "Colorado State University": "ncaaf_colorado_state",
  "Colorado State Rams": "ncaaf_colorado_state",
  Rams: "ncaaf_colorado_state",

  "Fresno State": "ncaaf_fresno_state",
  "California State University, Fresno": "ncaaf_fresno_state",
  "Fresno State Bulldogs": "ncaaf_fresno_state",

  Nevada: "ncaaf_nevada",
  "University of Nevada": "ncaaf_nevada",
  "Nevada Wolf Pack": "ncaaf_nevada",
  "Wolf Pack": "ncaaf_nevada",

  "New Mexico": "ncaaf_new_mexico",
  "University of New Mexico": "ncaaf_new_mexico",
  "New Mexico Lobos": "ncaaf_new_mexico",
  Lobos: "ncaaf_new_mexico",

  UNLV: "ncaaf_unlv",
  "University of Nevada, Las Vegas": "ncaaf_unlv",
  "UNLV Rebels": "ncaaf_unlv",
  Rebels: "ncaaf_unlv",

  "Utah State": "ncaaf_utah_state",
  "Utah State University": "ncaaf_utah_state",
  "Utah State Aggies": "ncaaf_utah_state",

  Wyoming: "ncaaf_wyoming",
  "University of Wyoming": "ncaaf_wyoming",
  "Wyoming Cowboys": "ncaaf_wyoming",

  "Hawai'i": "ncaaf_hawaii",
  "University of Hawaii": "ncaaf_hawaii",
  "Rainbow Warriors": "ncaaf_hawaii",

  "San Jose State": "ncaaf_san_jose_state",
  "San Jose State University": "ncaaf_san_jose_state",
  "San Jose State Spartans": "ncaaf_san_jose_state",

  USC: "ncaaf_usc",
  "University of Southern California": "ncaaf_usc",
  "USC Trojans": "ncaaf_usc",
  Trojans: "ncaaf_usc",

  "Arizona State": "ncaaf_arizona_state",
  "Arizona State University": "ncaaf_arizona_state",
  "Arizona State Sun Devils": "ncaaf_arizona_state",
  "Sun Devils": "ncaaf_arizona_state",

  Arizona: "ncaaf_arizona",
  "University of Arizona": "ncaaf_arizona",
  "Arizona Wildcats": "ncaaf_arizona",

  California: "ncaaf_california",
  "University of California, Berkeley": "ncaaf_california",
  "California Golden Bears": "ncaaf_california",
  "Golden Bears": "ncaaf_california",

  Colorado: "ncaaf_colorado",
  "University of Colorado Boulder": "ncaaf_colorado",
  "Colorado Buffaloes": "ncaaf_colorado",
  Buffaloes: "ncaaf_colorado",

  Oregon: "ncaaf_oregon",
  "University of Oregon": "ncaaf_oregon",
  "Oregon Ducks": "ncaaf_oregon",
  Ducks: "ncaaf_oregon",

  "Oregon State": "ncaaf_oregon_state",
  "Oregon State University": "ncaaf_oregon_state",
  "Oregon State Beavers": "ncaaf_oregon_state",
  Beavers: "ncaaf_oregon_state",

  Stanford: "ncaaf_stanford",
  "Stanford University": "ncaaf_stanford",
  "Stanford Cardinal": "ncaaf_stanford",
  Cardinal: "ncaaf_stanford",

  UCLA: "ncaaf_ucla",
  "University of California, Los Angeles": "ncaaf_ucla",
  "UCLA Bruins": "ncaaf_ucla",
  Bruins: "ncaaf_ucla",

  Utah: "ncaaf_utah",
  "University of Utah": "ncaaf_utah",
  "Utah Utes": "ncaaf_utah",
  Utes: "ncaaf_utah",

  Washington: "ncaaf_washington",
  "University of Washington": "ncaaf_washington",
  "Washington Huskies": "ncaaf_washington",

  "Washington State": "ncaaf_washington_state",
  "Washington State University": "ncaaf_washington_state",
  "Washington State Cougars": "ncaaf_washington_state",

  Vanderbilt: "ncaaf_vanderbilt",
  "Vanderbilt University": "ncaaf_vanderbilt",
  "Vanderbilt Commodores": "ncaaf_vanderbilt",
  Commodores: "ncaaf_vanderbilt",

  Florida: "ncaaf_florida",
  "University of Florida": "ncaaf_florida",
  "Florida Gators": "ncaaf_florida",
  Gators: "ncaaf_florida",

  Georgia: "ncaaf_georgia",
  "University of Georgia": "ncaaf_georgia",
  "Georgia Bulldogs": "ncaaf_georgia",

  Kentucky: "ncaaf_kentucky",
  "University of Kentucky": "ncaaf_kentucky",
  "Kentucky Wildcats": "ncaaf_kentucky",

  Missouri: "ncaaf_missouri",
  "University of Missouri": "ncaaf_missouri",
  "Missouri Tigers": "ncaaf_missouri",

  "South Carolina": "ncaaf_south_carolina",
  "University of South Carolina": "ncaaf_south_carolina",
  "South Carolina Gamecocks": "ncaaf_south_carolina",

  Tennessee: "ncaaf_tennessee",
  "University of Tennessee": "ncaaf_tennessee",
  "Tennessee Volunteers": "ncaaf_tennessee",
  Volunteers: "ncaaf_tennessee",

  Alabama: "ncaaf_alabama",
  "University of Alabama": "ncaaf_alabama",
  "Alabama Crimson Tide": "ncaaf_alabama",
  "Crimson Tide": "ncaaf_alabama",

  Arkansas: "ncaaf_arkansas",
  "University of Arkansas": "ncaaf_arkansas",
  "Arkansas Razorbacks": "ncaaf_arkansas",
  Razorbacks: "ncaaf_arkansas",

  Auburn: "ncaaf_auburn",
  "Auburn University": "ncaaf_auburn",
  "Auburn Tigers": "ncaaf_auburn",

  LSU: "ncaaf_lsu",
  "Louisiana State University": "ncaaf_lsu",
  "LSU Tigers": "ncaaf_lsu",

  "Mississippi State": "ncaaf_mississippi_state",
  "Mississippi State University": "ncaaf_mississippi_state",
  "Mississippi State Bulldogs": "ncaaf_mississippi_state",

  "Ole Miss": "ncaaf_ole_miss",
  "University of Mississippi": "ncaaf_ole_miss",
  "Ole Miss Rebels": "ncaaf_ole_miss",

  "Texas A&M": "ncaaf_texas_am",
  "Texas A&M University": "ncaaf_texas_am",
  "Texas A&M Aggies": "ncaaf_texas_am",

  "Appalachian State": "ncaaf_appalachian_state",
  "Appalachian State University": "ncaaf_appalachian_state",
  "Appalachian State Mountaineers": "ncaaf_appalachian_state",

  "Coastal Carolina": "ncaaf_coastal_carolina",
  "Coastal Carolina University": "ncaaf_coastal_carolina",
  "Coastal Carolina Chanticleers": "ncaaf_coastal_carolina",
  Chanticleers: "ncaaf_coastal_carolina",

  "Georgia Southern": "ncaaf_georgia_southern",
  "Georgia Southern University": "ncaaf_georgia_southern",
  "Georgia Southern Eagles": "ncaaf_georgia_southern",

  "Georgia State": "ncaaf_georgia_state",
  "Georgia State University": "ncaaf_georgia_state",
  "Georgia State Panthers": "ncaaf_georgia_state",

  "James Madison": "ncaaf_james_madison",
  "James Madison University": "ncaaf_james_madison",
  "James Madison Dukes": "ncaaf_james_madison",
  Dukes: "ncaaf_james_madison",

  Marshall: "ncaaf_marshall",
  "Marshall University": "ncaaf_marshall",
  "Marshall Thundering Herd": "ncaaf_marshall",
  "Thundering Herd": "ncaaf_marshall",

  "Old Dominion": "ncaaf_old_dominion",
  "Old Dominion University": "ncaaf_old_dominion",
  "Old Dominion Monarchs": "ncaaf_old_dominion",
  Monarchs: "ncaaf_old_dominion",

  "Arkansas State": "ncaaf_arkansas_state",
  "Arkansas State University": "ncaaf_arkansas_state",
  "Arkansas State Red Wolves": "ncaaf_arkansas_state",
  "Red Wolves": "ncaaf_arkansas_state",

  Louisiana: "ncaaf_louisiana",
  "University of Louisiana at Lafayette": "ncaaf_louisiana",
  "Louisiana Ragin' Cajuns": "ncaaf_louisiana",
  "Ragin' Cajuns": "ncaaf_louisiana",

  "South Alabama": "ncaaf_south_alabama",
  "University of South Alabama": "ncaaf_south_alabama",
  "South Alabama Jaguars": "ncaaf_south_alabama",
  Jaguars: "ncaaf_south_alabama",

  "Southern Miss": "ncaaf_southern_miss",
  "University of Southern Mississippi": "ncaaf_southern_miss",
  "Southern Miss Golden Eagles": "ncaaf_southern_miss",
  "Golden Eagles": "ncaaf_southern_miss",

  "Texas State": "ncaaf_texas_state",
  "Texas State University": "ncaaf_texas_state",
  "Texas State Bobcats": "ncaaf_texas_state",

  Troy: "ncaaf_troy",
  "Troy University": "ncaaf_troy",
  "Troy Trojans": "ncaaf_troy",

  "UL Monroe": "ncaaf_ul_monroe",
  ULM: "ncaaf_ul_monroe",
  "University of Louisiana Monroe": "ncaaf_ul_monroe",
  "UL Monroe Warhawks": "ncaaf_ul_monroe",
  "Louisiana-Monroe Warhawks": "ncaaf_ul_monroe",
  Warhawks: "ncaaf_ul_monroe",

  "Abilene Christian University": "ncaaf_abilene_christian",

  "Austin Peay State University": "ncaaf_austin_peay",
  Governors: "ncaaf_austin_peay",

  "University of Central Arkansas": "ncaaf_central_arkansas",

  "Eastern Kentucky University": "ncaaf_eastern_kentucky",
  Colonels: "ncaaf_eastern_kentucky",

  "Southern Utah University": "ncaaf_southern_utah",
  Thunderbirds: "ncaaf_southern_utah",

  "Stephen F. Austin": "ncaaf_stephen_f_austin",
  "Stephen F. Austin State University": "ncaaf_stephen_f_austin",
  "Stephen F. Austin Lumberjacks": "ncaaf_stephen_f_austin",
  Lumberjacks: "ncaaf_stephen_f_austin",

  Tarleton: "ncaaf_tarleton",
  "Tarleton University": "ncaaf_tarleton",
  "Tarleton Texans": "ncaaf_tarleton",
  Texans: "ncaaf_tarleton",

  "Utah Tech University": "ncaaf_utah_tech",

  "University of North Alabama": "ncaaf_north_alabama",
  Lions: "ncaaf_north_alabama",

  "California Polytechnic State University": "ncaaf_cal_poly",

  "Eastern Washington University": "ncaaf_eastern_washington",

  "Idaho State University": "ncaaf_idaho_state",
  Bengals: "ncaaf_idaho_state",

  "University of Idaho": "ncaaf_idaho",
  Vandals: "ncaaf_idaho",

  "University of Montana": "ncaaf_montana",
  Grizzlies: "ncaaf_montana",

  "Montana State University": "ncaaf_montana_state",

  "Northern Arizona University": "ncaaf_northern_arizona",

  "University of Northern Colorado": "ncaaf_northern_colorado",

  "Portland State University": "ncaaf_portland_state",

  "California State University, Sacramento": "ncaaf_sacramento_state",
  Hornets: "ncaaf_sacramento_state",

  "University of California, Davis": "ncaaf_uc_davis",

  "Weber State University": "ncaaf_weber_state",

  "Bryant University": "ncaaf_bryant",

  "Charleston Southern University": "ncaaf_charleston_southern",
  Buccaneers: "ncaaf_charleston_southern",

  "Eastern Illinois": "ncaaf_eastern_illinois",
  "Eastern Illinois University": "ncaaf_eastern_illinois",

  "Gardner-Webb University": "ncaaf_gardner_webb",

  "Lindenwood University": "ncaaf_lindenwood",

  "Robert Morris University": "ncaaf_robert_morris",
  Colonials: "ncaaf_robert_morris",

  "Southeast Missouri": "ncaaf_southeast_missouri",
  "Southeast Missouri State University": "ncaaf_southeast_missouri",
  "Southeast Missouri Redhawks": "ncaaf_southeast_missouri",
  Redhawks: "ncaaf_southeast_missouri",

  "Tennessee State": "ncaaf_tennessee_state",
  "Tennessee State University": "ncaaf_tennessee_state",

  "Tennessee Technological University": "ncaaf_tennessee_tech",

  "University of Tennessee at Martin": "ncaaf_ut_martin",
  Skyhawks: "ncaaf_ut_martin",

  "Campbell University": "ncaaf_campbell",
  "Fighting Camels": "ncaaf_campbell",

  "University of Delaware": "ncaaf_delaware",
  "Fightin' Blue Hens": "ncaaf_delaware",

  "Elon University": "ncaaf_elon",
  Phoenix: "ncaaf_elon",

  "Hampton University": "ncaaf_hampton",

  "University of Maine": "ncaaf_maine",
  "Black Bears": "ncaaf_maine",

  "Monmouth University": "ncaaf_monmouth",
  Hawks: "ncaaf_monmouth",

  "University of New Hampshire": "ncaaf_new_hampshire",

  "North Carolina A&T": "ncaaf_north_carolina_a_t",
  "North Carolina Agricultural and Technical State University":
    "ncaaf_north_carolina_a_t",
  "North Carolina A&T Aggies": "ncaaf_north_carolina_a_t",

  "University of Rhode Island": "ncaaf_rhode_island",

  "University of Richmond": "ncaaf_richmond",
  Spiders: "ncaaf_richmond",

  "Stony Brook University": "ncaaf_stony_brook",
  Seawolves: "ncaaf_stony_brook",

  "Towson University": "ncaaf_towson",

  "University at Albany, State University of New York": "ncaaf_ualbany",
  "Great Danes": "ncaaf_ualbany",

  "Villanova University": "ncaaf_villanova",

  "College of William & Mary": "ncaaf_william_and_mary",
  Tribe: "ncaaf_william_and_mary",

  "Brown University": "ncaaf_brown",

  "Columbia University": "ncaaf_columbia",

  "Cornell University": "ncaaf_cornell",
  "Big Red": "ncaaf_cornell",

  "Dartmouth College": "ncaaf_dartmouth",
  "Big Green": "ncaaf_dartmouth",

  "Harvard University": "ncaaf_harvard",
  Crimson: "ncaaf_harvard",

  Pennsylvania: "ncaaf_pennsylvania",
  "University of Pennsylvania": "ncaaf_pennsylvania",
  "Pennsylvania Quakers": "ncaaf_pennsylvania",
  Quakers: "ncaaf_pennsylvania",

  "Princeton University": "ncaaf_princeton",

  "Yale University": "ncaaf_yale",

  "Kennesaw State University": "ncaaf_kennesaw_state",

  "Delaware State": "ncaaf_delaware_state",
  "Delaware State University": "ncaaf_delaware_state",

  "Howard University": "ncaaf_howard",
  Bison: "ncaaf_howard",

  "Morgan State": "ncaaf_morgan_state",
  "Morgan State University": "ncaaf_morgan_state",

  "Norfolk State": "ncaaf_norfolk_state",
  "Norfolk State University": "ncaaf_norfolk_state",

  "North Carolina Central": "ncaaf_north_carolina_central",
  "North Carolina Central University": "ncaaf_north_carolina_central",
  "North Carolina Central Eagles": "ncaaf_north_carolina_central",

  "South Carolina State": "ncaaf_south_carolina_state",
  "South Carolina State University": "ncaaf_south_carolina_state",

  "Illinois State": "ncaaf_illinois_state",
  "Illinois State University": "ncaaf_illinois_state",
  Redbirds: "ncaaf_illinois_state",

  "Indiana State": "ncaaf_indiana_state",
  "Indiana State University": "ncaaf_indiana_state",
  Sycamores: "ncaaf_indiana_state",

  "Missouri State": "ncaaf_missouri_state",
  "Missouri State University": "ncaaf_missouri_state",

  "Murray State": "ncaaf_murray_state",
  "Murray State University": "ncaaf_murray_state",
  Racers: "ncaaf_murray_state",

  "University of North Dakota": "ncaaf_north_dakota",
  "Fighting Hawks": "ncaaf_north_dakota",

  "North Dakota State": "ncaaf_north_dakota_state",
  "North Dakota State University": "ncaaf_north_dakota_state",

  "Northern Iowa": "ncaaf_northern_iowa",
  "University of Northern Iowa": "ncaaf_northern_iowa",

  "University of South Dakota": "ncaaf_south_dakota",
  Coyotes: "ncaaf_south_dakota",

  "South Dakota State University": "ncaaf_south_dakota_state",
  "South Dakota State Jackrabbits": "ncaaf_south_dakota_state",
  Jackrabbits: "ncaaf_south_dakota_state",

  "Southern Illinois": "ncaaf_southern_illinois",
  "Southern Illinois University": "ncaaf_southern_illinois",
  Salukis: "ncaaf_southern_illinois",

  "Western Illinois": "ncaaf_western_illinois",
  "Western Illinois University": "ncaaf_western_illinois",
  Leathernecks: "ncaaf_western_illinois",

  "Youngstown State": "ncaaf_youngstown_state",
  "Youngstown State University": "ncaaf_youngstown_state",
  Penguins: "ncaaf_youngstown_state",

  "Central Connecticut": "ncaaf_central_connecticut",
  "Central Connecticut State University": "ncaaf_central_connecticut",
  "Central Connecticut Blue Devils": "ncaaf_central_connecticut",

  "Duquesne University": "ncaaf_duquesne",

  "Long Island University": "ncaaf_long_island_university",
  "Long Island University Brooklyn": "ncaaf_long_island_university",
  Sharks: "ncaaf_long_island_university",

  "Merrimack College": "ncaaf_merrimack",
  Warriors: "ncaaf_merrimack",

  "Sacred Heart University": "ncaaf_sacred_heart",
  Pioneers: "ncaaf_sacred_heart",

  "St. Francis (PA)": "ncaaf_st_francis_pa",
  "Saint Francis University": "ncaaf_st_francis_pa",
  "St. Francis Red Flash": "ncaaf_st_francis_pa",
  "Red Flash": "ncaaf_st_francis_pa",

  "Stonehill College": "ncaaf_stonehill",

  "Wagner College": "ncaaf_wagner",
  Seahawks: "ncaaf_wagner",

  "Bucknell University": "ncaaf_bucknell",

  "Colgate University": "ncaaf_colgate",
  Raiders: "ncaaf_colgate",

  "Georgetown University": "ncaaf_georgetown",
  Hoyas: "ncaaf_georgetown",

  "College of the Holy Cross": "ncaaf_holy_cross",
  Crusaders: "ncaaf_holy_cross",

  "Lafayette College": "ncaaf_lafayette",
  Leopards: "ncaaf_lafayette",

  "Lehigh University": "ncaaf_lehigh",
  "Mountain Hawks": "ncaaf_lehigh",

  "Fordham University": "ncaaf_fordham",

  "Butler University": "ncaaf_butler",

  "Davidson College": "ncaaf_davidson",

  "University of Dayton": "ncaaf_dayton",

  "Drake University": "ncaaf_drake",

  "Marist College": "ncaaf_marist",
  "Red Foxes": "ncaaf_marist",

  "Morehead State": "ncaaf_morehead_state",
  "Morehead State University": "ncaaf_morehead_state",

  "Presbyterian College": "ncaaf_presbyterian",
  "Blue Hose": "ncaaf_presbyterian",

  "University of San Diego": "ncaaf_san_diego",
  Toreros: "ncaaf_san_diego",

  "St. Thomas - Minnesota": "ncaaf_st_thomas_minnesota",
  "University of St. Thomas - Minnesota": "ncaaf_st_thomas_minnesota",
  Tommies: "ncaaf_st_thomas_minnesota",

  "Stetson University": "ncaaf_stetson",
  Hatters: "ncaaf_stetson",

  "Valparaiso University": "ncaaf_valparaiso",

  "Mercer University": "ncaaf_mercer",

  "University of Tennessee at Chattanooga": "ncaaf_chattanooga",
  Mocs: "ncaaf_chattanooga",

  "East Tennessee State": "ncaaf_east_tennessee_state",
  "East Tennessee State University": "ncaaf_east_tennessee_state",
  "East Tennessee State Buccaneers": "ncaaf_east_tennessee_state",

  "Furman University": "ncaaf_furman",
  Paladins: "ncaaf_furman",

  "Samford University": "ncaaf_samford",

  "The Citadel, The Military College of South Carolina": "ncaaf_the_citadel",

  "Virginia Military Institute": "ncaaf_vmi",
  Keydets: "ncaaf_vmi",

  "Western Carolina": "ncaaf_western_carolina",
  "Western Carolina University": "ncaaf_western_carolina",
  Catamounts: "ncaaf_western_carolina",

  "Wofford College": "ncaaf_wofford",
  Terriers: "ncaaf_wofford",

  "Houston Christian": "ncaaf_houston_christian",
  "Houston Christian University": "ncaaf_houston_christian",
  "Houston Christian Warriors": "ncaaf_houston_christian",

  "Incarnate Word": "ncaaf_incarnate_word",
  "University of the Incarnate Word": "ncaaf_incarnate_word",
  "Incarnate Word Cardinals": "ncaaf_incarnate_word",

  Lamar: "ncaaf_lamar",
  "Lamar University": "ncaaf_lamar",
  "Lamar Cardinals": "ncaaf_lamar",

  McNeese: "ncaaf_mcneese",
  "McNeese State University": "ncaaf_mcneese",
  "McNeese Cowboys": "ncaaf_mcneese",

  Nicholls: "ncaaf_nicholls",
  "Nicholls State University": "ncaaf_nicholls",
  "Nicholls Colonels": "ncaaf_nicholls",

  "Northwestern State": "ncaaf_northwestern_state",
  "Northwestern State University": "ncaaf_northwestern_state",
  "Northwestern State Demons": "ncaaf_northwestern_state",
  Demons: "ncaaf_northwestern_state",

  "SE Louisiana": "ncaaf_se_louisiana",
  "Southeastern Louisiana University": "ncaaf_se_louisiana",
  "SE Louisiana Lions": "ncaaf_se_louisiana",

  "Texas A&M-Commerce": "ncaaf_texas_am_commerce",
  "Texas A&M University-Commerce": "ncaaf_texas_am_commerce",
  "Texas A&M-Commerce Lions": "ncaaf_texas_am_commerce",

  "Jackson State": "ncaaf_jackson_state",
  "Jackson State University": "ncaaf_jackson_state",

  "Alabama A&M University": "ncaaf_alabama_am",

  "Alabama State University": "ncaaf_alabama_state",

  "Bethune-Cookman University": "ncaaf_bethune_cookman",

  "Florida A&M University": "ncaaf_florida_am",
  Rattlers: "ncaaf_florida_am",

  "Mississippi Valley State": "ncaaf_mississippi_valley_state",
  "Mississippi Valley State University": "ncaaf_mississippi_valley_state",
  "Delta Devils": "ncaaf_mississippi_valley_state",

  "Alcorn State": "ncaaf_alcorn_state",
  "Alcorn State University": "ncaaf_alcorn_state",

  "Arkansas-Pine Bluff": "ncaaf_arkansas_pine_bluff",
  "University of Arkansas at Pine Bluff": "ncaaf_arkansas_pine_bluff",
  "Golden Lions": "ncaaf_arkansas_pine_bluff",

  "Grambling State University": "ncaaf_grambling",
  "Grambling Tigers": "ncaaf_grambling",

  "Prairie View A&M": "ncaaf_prairie_view_am",
  "Prairie View A&M University": "ncaaf_prairie_view_am",

  Southern: "ncaaf_southern",
  "Southern University": "ncaaf_southern",

  "Texas Southern University": "ncaaf_texas_southern",


};

function standarizerFromMaps(
  location: string,
  ...maps: { [key: string]: string | string[] }[]
) {
  const alerted: any = {};

  return (label: string) => {
    try {
      const cleanTeam = label.trim().replace(/ [@]/g, "").trim();

      for (const source of maps) {
        const val = source[cleanTeam];

        if (Array.isArray(val) && val.length > 0) {
          return val[0];
        } else if (val) {
          return val as string;
        }
      }

      // only alert once
      if (!alerted[cleanTeam]) {
        alerted[cleanTeam] = true;

        logger.info(
          "Unable to standardize team for " + cleanTeam + " for " + location
        );
      }
    } catch (e) {
      logger.info(
        e,
        "Unable to standardize team for " + location + " due to error"
      );
    }

    return "";
  };
}

function possibleStandarizerFromMaps(
  location: string,
  ...maps: { [key: string]: string | string[] }[]
): SbPossibleTeamStandardizer {
  const alerted: any = {};

  return (label: string) => {
    const cleanTeam = label.trim().replace(/ [@]/g, "").trim();

    for (const source of maps) {
      const val = source[cleanTeam];

      if (Array.isArray(val)) {
        return val;
      } else if (val) {
        return [val];
      }
    }

    // only alert once
    if (!alerted[cleanTeam]) {
      alerted[cleanTeam] = true;

      logger.info(
        "Unable to standardize team for " + cleanTeam + " for " + location
      );
    }

    return [];
  };
}

function standardizeTeamFromPossibilities(
  line: string,
  possible: string[],
  potentialStandardizer: SbPossibleTeamStandardizer
): string {
  const potentials = potentialStandardizer(line);

  for (const potential of potentials) {
    if (possible.includes(potential)) {
      return potential;
    }
  }

  return "";
}

function simpleTeamsFromPageScan(
  standardizer: SbTeamStandardizer
): SbTeamsMessageReader {
  return (message: any) => {
    let data = [];

    for (const t of message.value.teams) {
      data.push(standardizer(t));
    }
    data.sort();

    // logger.debug("Teams: ", data);
    return data;
  };
}

function guessTeams(
  rawTeamList: string[],
  standardizer: SbPossibleTeamStandardizer
): string[] {
  let data = [] as string[][];

  for (const t of rawTeamList) {
    data.push(standardizer(t));
  }

  let possible: string[][] = [];
  for (const pTeams of data) {
    // logger.debug(pTeams);

    if (pTeams.length > 1) {
      if (possible.length > 0) {
        const oldPossible = possible;
        possible = [];
        for (const chunk of pTeams) {
          for (const i of oldPossible) {
            const chunkItem = [...i];
            chunkItem.push(chunk);
            possible.push(chunkItem);
          }
        }
      } else {
        for (const team of pTeams) {
          possible.push([team]);
        }
      }
    } else {
      const team = pTeams.length > 0 ? pTeams[0] : "";

      if (possible.length > 0) {
        for (const chunk of possible) {
          chunk.push(team);
        }
      } else {
        possible.push([team]);
      }
    }
  }

  // logger.debug("Possible: ", possible);

  if (possible.length == 0) {
    return [];
  }

  // now filter for bad mixed sports
  for (const potential of possible) {
    if (potential.length > 0) {
      const sport = getSport(potential[0]);
      let good: boolean = true;
      for (const testTeam of potential) {
        if (sport != getSport(testTeam)) {
          good = false;
        }
      }

      if (good) {
        potential.sort();
        // logger.debug("Found: ", potential);
        return potential;
      }
    }
  }

  // logger.debug("Teams: ", data);
  return [];
}

function getSport(team: string) {
  if (team.length > 0) {
    return team.replace(/[_].*/g, "");
  } else {
    return "";
  }
}

function teamsGuesserFromPageScan(
  standardizer: SbPossibleTeamStandardizer
): SbTeamsMessageReader {
  return (message: any) => {
    return guessTeams(message.value.teams, standardizer);
  };
}

function simpleGameStandardizer(
  standardizer: SbPossibleTeamStandardizer
): SbGameStandardizer {
  return (teams: string[]) => {
    return guessTeams(teams, standardizer);
  };
}

function migratedOddsV1Live(message: any): boolean {
  return message.value.live.length > 0;
}

function migratedOddsV1Scanner(
  standardizer: SbTeamStandardizer,
  moneyLineDisabledIncludes?: string
): SbLinesMessageReader {
  return (message: any, oddsSink: OddsSink.OddsSink) => {
    const ml = message.value.moneyline;
    const mlA = message.value.moneylineAttr;

    if (ml && ml.length == 0) {
      for (const team of message.value.teams) {
        const cleanTeam = standardizer(team);
        oddsSink.setMoneyline(cleanTeam, NaN);
      }
    } else if (ml && ml.length == 2) {
      for (let i = 0; i < message.value.teams.length; i++) {
        let disable = false;

        if (moneyLineDisabledIncludes && mlA && mlA.length == 2 && mlA[i]) {
          disable = mlA[i].includes(moneyLineDisabledIncludes);
        }

        const cleanTeam = standardizer(message.value.teams[i]);
        const cleanOdds = disable ? NaN : readOdds(ml[i]);
        oddsSink.setMoneyline(cleanTeam, cleanOdds);
      }
    }
  };
}

/**
 * Page Scanner version of time reader. Will work with messages that have
 * a text array of a single element, otherwise returns null.
 *
 * @param original original reader
 * @returns function for page scanner
 */
function migratedV1TimeReaderImpl(
  location: string,
  logError: boolean,
  ignoreArrayLen: boolean,
  original: SbTimeReader
) {
  return (rcvTime: Date, message: any) => {
    const valArr = message.value.time;

    if (!valArr) {
      if (logError) {
        logger.warn("Message time was not set ", location, ": ", message);
      }
      return null;
    }

    if (typeof valArr === "string" || valArr instanceof String) {
      return original(rcvTime, valArr as string);
    }

    if (!Array.isArray(valArr)) {
      if (logError) {
        logger.warn(
          "Message time was not an array or simple string for ",
          location,
          ": ",
          message
        );
      }
      return null;
    }

    const arr = valArr as string[];
    if (arr.length != 1) {
      if (logError && (!ignoreArrayLen || arr.length > 1)) {
        logger.warn(
          "Message time array was not of length 1 at ",
          location,
          ": ",
          message
        );
      }

      return null;
    }

    return original(rcvTime, arr[0]);
  };
}

/**
 * Page Scanner version of time reader. Will work with messages that have
 * a text array of a single element, otherwise returns null.
 *
 * @param original original reader
 * @returns function for page scanner
 */
function migratedV1TimeReader(
  location: string,
  logError: boolean,
  original: SbTimeReader
) {
  return migratedV1TimeReaderImpl(location, logError, false, original);
}

/**
 * Page Scanner version of time reader. Will work with messages that have
 * a text array of a single element, otherwise returns null.
 *
 * @param original original reader
 * @returns function for page scanner
 */
function migratedV1TimeReaderIgnoreLen(
  location: string,
  logError: boolean,
  original: SbTimeReader
) {
  return migratedV1TimeReaderImpl(location, logError, true, original);
}

function LoggingNullTimeReader(location: string, log: boolean): SbTimeReader {
  return (rcvTime: Date, label: string) => {
    if (log) {
      logger.info(
        "Request convert for time from ",
        location,
        " at ",
        rcvTime,
        " of ",
        label
      );
    }

    return null;
  };
}

function genericTeamSplitter(location: string) {
  return (teamStr: string) => {
    const out = teamStr.split(/ (?:vs|[@]|at|v) /);

    if (out.length != 2) {
      logger.warn(
        "Unexpected betslip teams from ",
        location,
        ":",
        teamStr,
        " produced ",
        out
      );
    }

    return out;
  };
}

function readOdds(value: string): number {
  const num = parseInt(value.trim().replace(/^[+]/, "").trim());

  if (num > -100 && num < 100) {
    // these don't make sense in american odds...
    return NaN;
  }

  return num;
}

function readSpreadLine(wager: string): number[] {
  const runMatch = /^([+\-]?\d+[.]?\d*) *([+\-]\d+)$/i.exec(wager);
  if (runMatch) {
    const hc = parseFloat(runMatch[1]);
    const cleanRLOdds = readOdds(runMatch[2]);
    return [hc, cleanRLOdds];
  } else {
    return [NaN, NaN];
  }
}

function readTotal(wager: string, odds = true): number[] {
  const noOdds = /([OoUu])[vn]?[der]* *(\d+[.]?\d*)/;
  const withOdds = /([OoUu])[vn]?[der]* *(\d+[.]?\d*) *([+\-]\d+)/;
  const totMatch = (odds ? withOdds : noOdds).exec(wager);
  if (totMatch) {
    const type = totMatch[1];
    const score = parseFloat(totMatch[2]);
    const cleanTOdds = odds ? readOdds(totMatch[3]) : NaN;
    if (type === "O" || type === "o") {
      return [score, cleanTOdds];
    } else if (type == "U" || type == "u") {
      return [-score, cleanTOdds];
    }
  }

  return [NaN, NaN];
}

/**
 * reads line name in format of [team] +/-(num)
 *
 *  example: Royals +1.5
 * @param lineName line name to read
 * @returns [team, spread]
 */
function readTeamSpreadLine(lineName: string): [string, number] {
  const runMatch = /^(.*) ([+/-]?\d+[.]?\d*)$/i.exec(lineName);
  if (runMatch) {
    const team = runMatch[1];
    const spread = parseFloat(runMatch[2].trim());

    return [team, spread];
  }

  return ["", NaN];
}

export {
  standarizerFromMaps,
  StandardTeams,
  simpleTeamsFromPageScan,
  teamsGuesserFromPageScan,
  guessTeams,
  migratedOddsV1Scanner,
  migratedOddsV1Live,
  LoggingNullTimeReader,
  migratedV1TimeReader,
  migratedV1TimeReaderIgnoreLen,
  possibleStandarizerFromMaps,
  simpleGameStandardizer,
  genericTeamSplitter,
  readOdds,
  readSpreadLine,
  readTeamSpreadLine,
  readTotal,
  standardizeTeamFromPossibilities,
  OddsSink,
};
