"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLatestLog = exports.topicLogger = exports.rawLogger = void 0;
const winston = require("winston");
const DailyRotateFile = require("winston-daily-rotate-file");
const fs = require("fs");
const util = require("util");
// const cwd = process.cwd();
const logPath = "logs";
if (!fs.existsSync(logPath)) {
    fs.mkdirSync(logPath);
}
const rollingFileTransport = new DailyRotateFile({
    dirname: "logs",
    filename: "log-%DATE%.log",
    datePattern: "YYYYMMDD-HH",
    maxSize: "50k",
    json: true,
    format: winston.format.combine(winston.format.errors({ stack: true }), winston.format.timestamp(), winston.format.json()),
});
function getLatestLog() {
    const files = fs.readdirSync(logPath);
    let bestMTime = -1;
    let latestFile = null;
    files.forEach((file) => {
        const filePath = `${logPath}/${file}`;
        const stats = fs.statSync(filePath);
        const mtime = stats.mtimeMs;
        // console.log("getLatestLog: ", filePath, " @", mtime);
        if (mtime > bestMTime) {
            // console.log("Set file to ", filePath);
            bestMTime = mtime;
            latestFile = filePath;
        }
    });
    // console.log("getLatestLog return: ", latestFile);
    return latestFile;
}
exports.getLatestLog = getLatestLog;
// function archiveLogs() {
//   const files = fs.readdirSync(logPath);
//   files.forEach((file) => {
//     const filePath = `${logPath}/${file}`;
//     if (file.endsWith(".log")) {
//     } else {
//       fs.renameSync(filePath, `${archiveFolder}/${file}`);
//     }
//     const stats = fs.statSync(filePath);
//     const fileSizeInBytes = stats.size;
//     if (fileSizeInBytes > 5000) {
//     }
//   });
// }
// rollingFileTransport.on("rotate", function (oldFilename, newFilename) {
//   const archiveFolder = path.join(logPath, "archive");
//   if (!fs.existsSync(archiveFolder)) {
//     fs.mkdirSync(archiveFolder);
//   }
//   console.log("\n\n\n\n ******** ");
//   console.log("Rotate: ", oldFilename, newFilename);
//   console.log("old exists? ", fs.existsSync(oldFilename));
//   console.log("new exists? ", fs.existsSync(newFilename));
//   console.log(" ******** \n\n\n\n");
// });
const rawLogger = winston.createLogger({
    level: "info",
    transports: [rollingFileTransport],
});
exports.rawLogger = rawLogger;
if (process.env.NODE_ENV !== "production") {
    rawLogger.add(new winston.transports.Console({
        format: winston.format.simple(),
    }));
}
const topicLogger = function (topic) {
    const log = function (level, message) {
        try {
            rawLogger.log(level, { topic, message: JSON.stringify(message) });
        }
        catch (e) {
            rawLogger.log(level, { topic, message });
        }
    };
    return {
        warn: function (...args) {
            log("warn", util.format.apply({}, args));
        },
        info: function (...args) {
            log("info", util.format.apply({}, args));
        },
        debug: function (...args) {
            log("debug", util.format.apply({}, args));
        },
        error: function (...args) {
            log("error", util.format.apply({}, args));
        },
    };
};
exports.topicLogger = topicLogger;
