"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.settings = void 0;
const yaml = require("js-yaml");
const fs = require("fs");
const path = require("path");
const lodash = require("lodash");
const process = require("process");
const jsonpath = require("jsonpath");
const CryptUtils = require("./CryptUtils");
const crypto = require("crypto");
let srcDoc = "";
const cwd = process.cwd();
function findFile(file, name, required = true) {
    for (const trySrc of ["settings", "../settings"]) {
        let tryPath = path.resolve(cwd, trySrc, file);
        if (fs.existsSync(tryPath)) {
            return tryPath;
        }
    }
    if (required) {
        throw ("Unable to find default settings " + file + " in " + cwd + " for " + name);
    }
    return null;
}
function loadFile(sourceName, file) {
    if (!file) {
        console.error("File ", file, " does not exist. Not loading");
        return {};
    }
    const settingsFile = findFile(file);
    console.error("Loading " + sourceName + " settings from ", settingsFile);
    try {
        const fileData = fs.readFileSync(settingsFile, "utf8");
        return yaml.load(fileData);
    }
    catch (e) {
        console.error(e, "Error loading ", sourceName, " settings");
    }
}
const generalDoc = yaml.load(fs.readFileSync(findFile("default.settings.yaml"), "utf8"));
// console.log("General doc: ", generalDoc);
let file = "local.settings.yaml";
if (process.env.settings_file) {
    file = process.env.settings_file;
}
else {
    const newEnvPath = path.resolve(cwd, "env");
    if (fs.existsSync(newEnvPath)) {
        file = null;
        const point = fs.readFileSync(newEnvPath, "utf8");
        if (point) {
            file = point.trim();
        }
    }
}
let specificDoc = loadFile("env", file);
let envSettings = loadFile("credentials", findFile(".autengreers", "credentials", false)); // credentials, but in a weird name so it's hard to auto scan find
const settings = lodash.merge(generalDoc, specificDoc, envSettings).settings;
exports.settings = settings;
jsonpath.apply(settings, "$..*", (a) => {
    if (a && typeof a === "string" && a.startsWith("encrypted:")) {
        let val = null;
        try {
            val = CryptUtils.decryptData(null, a);
        }
        catch (e) {
            console.error(e);
        }
        if (!val) {
            console.error("Problem decrypting value of ", a);
            return "decrypt_error|salt:" + crypto.randomUUID();
        }
        return val;
    }
    else {
        return a;
    }
});
