type oddSet = {
    [key: string]: number;
};
type bookSet = {
    [key2: string]: oddSet;
};
type cacheSet = {
    [key: string]: bookSet;
};
type updateListener = (key: string, location: string, odds: oddSet) => void;
type OddsTrackerSettings = {
    liveAgeOut?: {
        [key: string]: number;
    };
    otherAgeOut?: {
        [key: string]: number;
    };
};
declare class OddsTracker {
    odds: cacheSet;
    impliedOdds: cacheSet;
    ageOut: {
        [key: string]: {
            [key2: string]: number;
        };
    };
    cleanout: any;
    lastUpdate: number;
    listeners: updateListener[];
    liveAgeOut: {
        [key: string]: number;
    };
    otherAgeOut: {
        [key: string]: number;
    };
    constructor(settings?: OddsTrackerSettings);
    cleanup(): void;
    emptyOdds(): void;
    updateOSAll(contents: any, merge: boolean): void;
    calcImpliedOdds(odds: oddSet): oddSet;
    updateOS(key: string, location: string, odds: oddSet, merge: boolean): void;
    addListener(listener: updateListener): void;
    getAgeOut(location: string, live: boolean): number;
    getLastUpdated(): number;
    getLiveEvents(): cacheSet;
    getPregameEvents(): cacheSet;
    getAllEvents(): cacheSet;
    getElementCount(): number;
    diagnostics(): any;
}
export { OddsTracker, oddSet, cacheSet, bookSet };
