"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MoneylineOddsCollectionSink = void 0;
class MoneylineOddsCollectionSink {
    constructor() {
        this.odds = {};
    }
    setMoneyline(standardizedTeam, odds) {
        this.odds[standardizedTeam] = odds;
    }
    setSpread(standardizedTeam, spread, odds) {
        if (!isNaN(spread)) {
            let spreadStr = ("" + spread);
            if (spread > 0 && spreadStr.indexOf("+") < 0) {
                spreadStr = "+" + spreadStr;
            }
            this.odds["$" + standardizedTeam + spreadStr] = odds;
        }
    }
    setOver(total, odds) {
        if (!isNaN(total)) {
            this.odds["$over" + total] = odds;
        }
    }
    setUnder(total, odds) {
        if (!isNaN(total)) {
            this.odds["$under" + total] = odds;
        }
    }
    setTotal(total, odds) {
        if (total < 0) {
            this.setUnder(Math.abs(total), odds);
        }
        else {
            this.setOver(total, odds);
        }
    }
    getOdds() {
        return this.odds;
    }
}
exports.MoneylineOddsCollectionSink = MoneylineOddsCollectionSink;
