import * as OddsTracker from "./OddsTracker";
interface OddsSink {
    setMoneyline(standardizedTeam: string, odds: number): void;
    setSpread(standardizedTeam: string, spread: number, odds: number): void;
    setOver(total: number, odds: number): void;
    setUnder(total: number, odds: number): void;
    /**
     * Convienence method for over/under set. Negative means under, positive over.
     * @param total The strike. Positive for over, Negative for under
     * @param odds american odds
     */
    setTotal(total: number, odds: number): void;
}
declare class MoneylineOddsCollectionSink implements OddsSink {
    odds: OddsTracker.oddSet;
    setMoneyline(standardizedTeam: string, odds: number): void;
    setSpread(standardizedTeam: string, spread: number, odds: number): void;
    setOver(total: number, odds: number): void;
    setUnder(total: number, odds: number): void;
    setTotal(total: number, odds: number): void;
    getOdds(): OddsTracker.oddSet;
}
export { MoneylineOddsCollectionSink, OddsSink };
