/// <reference types="node" />
/// <reference types="node" />
import * as WebSocket from "ws";
import * as http from "http";
type Authenticator = (message: any, ws: WebSocket) => string;
declare class MessagingSocketServer {
    wss: WebSocket.Server;
    messageHandlers: Map<string, Function>;
    connectionListeners: Array<Function>;
    authenticationListeners: Array<Function>;
    logger: any;
    authenticator: Authenticator;
    cleanupinterval: NodeJS.Timeout;
    constructor(logname: string);
    setAuthenticator(authenticator: Authenticator): void;
    addConnectionListener(listener: Function): void;
    addAuthenticationListener(listener: Function): void;
    registerMessageHandler(type: string, handler: any): void;
    broadcast(type: string, message: any): void;
    forEach(f: (ws: WebSocket) => void): void;
    open(path: string, server: http.Server): void;
}
export { MessagingSocketServer };
