"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildRoutes = void 0;
const express = require("express");
const logging = require("./logger");
const logger = logging.topicLogger("loggerApi");
const fs = require("fs");
function buildRoutes() {
    const router = express.Router();
    let logs = null;
    setInterval(() => {
        logs = null;
    }, 15000);
    router.get("/logs/last", async function (req, res) {
        if (logs) {
            res.json(logs);
        }
        else {
            const latestLogFile = logging.getLatestLog();
            if (latestLogFile && latestLogFile.length > 0) {
                const logData = await fs.promises.readFile(latestLogFile, "utf8");
                logs = [];
                const parts = logData.split("\n");
                for (const part of parts) {
                    try {
                        if (part.length > 0) {
                            logs.push(JSON.parse(part));
                        }
                    }
                    catch (e) {
                        logger.error("Error parsing log line: ", part, e);
                    }
                }
                logs = { status: "success", results: logs };
                res.json(logs);
            }
            else {
                res.send({ status: "nologs", results: [] });
            }
        }
    });
    return router;
}
exports.buildRoutes = buildRoutes;
