import * as OddsSink from "./OddsSink";
type SbTimeReader = (rcvTime: Date, label: string) => Date | null;
type SbTeamStandardizer = (label: string) => string;
type SbGameStandardizer = (labels: string[], timeHint?: string) => string[];
type SbPossibleTeamStandardizer = (label: string) => string[];
type SbTeamsMessageReader = (message: any) => string[];
type SbLinesMessageReader = (message: any, oddsSink: OddsSink.OddsSink) => void;
declare const StandardTeams: {
    [key: string]: string | string[];
};
declare function standarizerFromMaps(location: string, ...maps: {
    [key: string]: string | string[];
}[]): (label: string) => string;
declare function possibleStandarizerFromMaps(location: string, ...maps: {
    [key: string]: string | string[];
}[]): SbPossibleTeamStandardizer;
declare function standardizeTeamFromPossibilities(line: string, possible: string[], potentialStandardizer: SbPossibleTeamStandardizer): string;
declare function simpleTeamsFromPageScan(standardizer: SbTeamStandardizer): SbTeamsMessageReader;
declare function guessTeams(rawTeamList: string[], standardizer: SbPossibleTeamStandardizer): string[];
declare function teamsGuesserFromPageScan(standardizer: SbPossibleTeamStandardizer): SbTeamsMessageReader;
declare function simpleGameStandardizer(standardizer: SbPossibleTeamStandardizer): SbGameStandardizer;
declare function migratedOddsV1Live(message: any): boolean;
declare function migratedOddsV1Scanner(standardizer: SbTeamStandardizer, moneyLineDisabledIncludes?: string): SbLinesMessageReader;
/**
 * Page Scanner version of time reader. Will work with messages that have
 * a text array of a single element, otherwise returns null.
 *
 * @param original original reader
 * @returns function for page scanner
 */
declare function migratedV1TimeReader(location: string, logError: boolean, original: SbTimeReader): (rcvTime: Date, message: any) => Date;
/**
 * Page Scanner version of time reader. Will work with messages that have
 * a text array of a single element, otherwise returns null.
 *
 * @param original original reader
 * @returns function for page scanner
 */
declare function migratedV1TimeReaderIgnoreLen(location: string, logError: boolean, original: SbTimeReader): (rcvTime: Date, message: any) => Date;
declare function LoggingNullTimeReader(location: string, log: boolean): SbTimeReader;
declare function genericTeamSplitter(location: string): (teamStr: string) => string[];
declare function readOdds(value: string): number;
declare function readSpreadLine(wager: string): number[];
declare function readTotal(wager: string, odds?: boolean): number[];
/**
 * reads line name in format of [team] +/-(num)
 *
 *  example: Royals +1.5
 * @param lineName line name to read
 * @returns [team, spread]
 */
declare function readTeamSpreadLine(lineName: string): [string, number];
export { standarizerFromMaps, StandardTeams, simpleTeamsFromPageScan, teamsGuesserFromPageScan, guessTeams, migratedOddsV1Scanner, migratedOddsV1Live, LoggingNullTimeReader, migratedV1TimeReader, migratedV1TimeReaderIgnoreLen, possibleStandarizerFromMaps, simpleGameStandardizer, genericTeamSplitter, readOdds, readSpreadLine, readTeamSpreadLine, readTotal, standardizeTeamFromPossibilities, OddsSink, };
